/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.ipc;

import cdjd.org.apache.arrow.util.VisibleForTesting;
import cdjd.org.apache.arrow.vector.VectorSchemaRoot;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryProvider;
import cdjd.org.apache.arrow.vector.ipc.ArrowMagic;
import cdjd.org.apache.arrow.vector.ipc.ArrowWriter;
import cdjd.org.apache.arrow.vector.ipc.InvalidArrowFileException;
import cdjd.org.apache.arrow.vector.ipc.WriteChannel;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowBlock;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFooter;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import cdjd.org.apache.arrow.vector.ipc.message.IpcOption;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowFileWriter
extends ArrowWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowFileWriter.class);
    private final List<ArrowBlock> dictionaryBlocks = new ArrayList<ArrowBlock>();
    private final List<ArrowBlock> recordBlocks = new ArrayList<ArrowBlock>();
    private Map<String, String> metaData;

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out) {
        super(root, provider, out);
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData) {
        super(root, provider, out);
        this.metaData = metaData;
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, IpcOption option) {
        super(root, provider, out, option);
    }

    @Override
    protected void startInternal(WriteChannel out) throws IOException {
        ArrowMagic.writeMagic(out, true);
    }

    @Override
    protected ArrowBlock writeDictionaryBatch(ArrowDictionaryBatch batch) throws IOException {
        ArrowBlock block = super.writeDictionaryBatch(batch);
        this.dictionaryBlocks.add(block);
        return block;
    }

    @Override
    protected ArrowBlock writeRecordBatch(ArrowRecordBatch batch) throws IOException {
        ArrowBlock block = super.writeRecordBatch(batch);
        this.recordBlocks.add(block);
        return block;
    }

    @Override
    protected void endInternal(WriteChannel out) throws IOException {
        if (!this.option.write_legacy_ipc_format) {
            out.writeIntLittleEndian(-1);
        }
        out.writeIntLittleEndian(0);
        long footerStart = out.getCurrentPosition();
        out.write(new ArrowFooter(this.schema, this.dictionaryBlocks, this.recordBlocks, this.metaData), false);
        int footerLength = (int)(out.getCurrentPosition() - footerStart);
        if (footerLength <= 0) {
            throw new InvalidArrowFileException("invalid footer");
        }
        out.writeIntLittleEndian(footerLength);
        LOGGER.debug("Footer starts at {}, length: {}", (Object)footerStart, (Object)footerLength);
        ArrowMagic.writeMagic(out, false);
        LOGGER.debug("magic written, now at {}", (Object)out.getCurrentPosition());
    }

    @VisibleForTesting
    public List<ArrowBlock> getRecordBlocks() {
        return this.recordBlocks;
    }

    @VisibleForTesting
    public List<ArrowBlock> getDictionaryBlocks() {
        return this.dictionaryBlocks;
    }
}

