/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.dictionary;

import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import cdjd.org.apache.arrow.memory.util.hash.SimpleHasher;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BaseIntVector;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.complex.StructVector;
import cdjd.org.apache.arrow.vector.dictionary.Dictionary;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryEncoder;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryHashTable;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryProvider;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StructSubfieldEncoder {
    private final BufferAllocator allocator;
    private final DictionaryProvider.MapDictionaryProvider provider;
    private final Map<Long, DictionaryHashTable> dictionaryIdToHashTable;

    public StructSubfieldEncoder(BufferAllocator allocator, DictionaryProvider.MapDictionaryProvider provider) {
        this(allocator, provider, SimpleHasher.INSTANCE);
    }

    public StructSubfieldEncoder(BufferAllocator allocator, DictionaryProvider.MapDictionaryProvider provider, ArrowBufHasher hasher) {
        this.allocator = allocator;
        this.provider = provider;
        this.dictionaryIdToHashTable = new HashMap<Long, DictionaryHashTable>();
        provider.getDictionaryIds().forEach(id -> this.dictionaryIdToHashTable.put((Long)id, new DictionaryHashTable(provider.lookup((long)id).getVector(), hasher)));
    }

    private FieldVector getChildVector(StructVector vector, int index) {
        return vector.getChildrenFromFields().get(index);
    }

    private StructVector cloneVector(StructVector vector) {
        FieldType fieldType = vector.getField().getFieldType();
        StructVector cloned = (StructVector)fieldType.createNewSingleVector(vector.getField().getName(), this.allocator, null);
        ArrowFieldNode fieldNode = new ArrowFieldNode(vector.getValueCount(), vector.getNullCount());
        cloned.loadFieldBuffers(fieldNode, vector.getFieldBuffers());
        return cloned;
    }

    public StructVector encode(StructVector vector, Map<Integer, Long> columnToDictionaryId) {
        int valueCount = vector.getValueCount();
        int childCount = vector.getChildrenFromFields().size();
        ArrayList<Field> childrenFields = new ArrayList<Field>();
        for (int i = 0; i < childCount; ++i) {
            FieldVector childVector = this.getChildVector(vector, i);
            Long dictionaryId = columnToDictionaryId.get(i);
            if (dictionaryId == null) {
                childrenFields.add(childVector.getField());
                continue;
            }
            Dictionary dictionary = this.provider.lookup(dictionaryId);
            Preconditions.checkNotNull(dictionary, "Dictionary not found with id:" + dictionaryId);
            FieldType indexFieldType = new FieldType(childVector.getField().isNullable(), dictionary.getEncoding().getIndexType(), dictionary.getEncoding());
            childrenFields.add(new Field(childVector.getField().getName(), indexFieldType, null));
        }
        StructVector encoded = this.cloneVector(vector);
        encoded.initializeChildrenFromFields(childrenFields);
        encoded.setValueCount(valueCount);
        for (int index = 0; index < childCount; ++index) {
            FieldVector childVector = this.getChildVector(vector, index);
            FieldVector encodedChildVector = this.getChildVector(encoded, index);
            Long dictionaryId = columnToDictionaryId.get(index);
            if (dictionaryId != null) {
                BaseIntVector indices = (BaseIntVector)encodedChildVector;
                DictionaryEncoder.buildIndexVector(childVector, indices, this.dictionaryIdToHashTable.get(dictionaryId), 0, valueCount);
                continue;
            }
            childVector.makeTransferPair(encodedChildVector).splitAndTransfer(0, valueCount);
        }
        return encoded;
    }

    public StructVector decode(StructVector vector) {
        FieldVector childVector;
        int valueCount = vector.getValueCount();
        int childCount = vector.getChildrenFromFields().size();
        StructVector decoded = this.cloneVector(vector);
        ArrayList<Field> childFields = new ArrayList<Field>();
        for (int i = 0; i < childCount; ++i) {
            childVector = this.getChildVector(vector, i);
            Dictionary dictionary = this.getChildVectorDictionary(childVector);
            if (dictionary == null) {
                childFields.add(childVector.getField());
                continue;
            }
            childFields.add(dictionary.getVector().getField());
        }
        decoded.initializeChildrenFromFields(childFields);
        decoded.setValueCount(valueCount);
        for (int index = 0; index < childCount; ++index) {
            childVector = this.getChildVector(vector, index);
            FieldVector decodedChildVector = this.getChildVector(decoded, index);
            Dictionary dictionary = this.getChildVectorDictionary(childVector);
            if (dictionary == null) {
                childVector.makeTransferPair(decodedChildVector).splitAndTransfer(0, valueCount);
                continue;
            }
            TransferPair transfer = dictionary.getVector().makeTransferPair(decodedChildVector);
            BaseIntVector indices = (BaseIntVector)childVector;
            DictionaryEncoder.retrieveIndexVector(indices, transfer, valueCount, 0, valueCount);
        }
        return decoded;
    }

    private Dictionary getChildVectorDictionary(FieldVector childVector) {
        DictionaryEncoding dictionaryEncoding = childVector.getField().getDictionary();
        if (dictionaryEncoding != null) {
            Dictionary dictionary = this.provider.lookup(dictionaryEncoding.getId());
            Preconditions.checkNotNull(dictionary, "Dictionary not found with id:" + dictionary);
            return dictionary;
        }
        return null;
    }
}

