/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.dictionary;

import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import cdjd.org.apache.arrow.memory.util.hash.SimpleHasher;
import cdjd.org.apache.arrow.vector.BaseIntVector;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.complex.BaseListVector;
import cdjd.org.apache.arrow.vector.dictionary.Dictionary;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryEncoder;
import cdjd.org.apache.arrow.vector.dictionary.DictionaryHashTable;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.util.Collections;

public class ListSubfieldEncoder {
    private final DictionaryHashTable hashTable;
    private final Dictionary dictionary;
    private final BufferAllocator allocator;

    public ListSubfieldEncoder(Dictionary dictionary, BufferAllocator allocator) {
        this(dictionary, allocator, SimpleHasher.INSTANCE);
    }

    public ListSubfieldEncoder(Dictionary dictionary, BufferAllocator allocator, ArrowBufHasher hasher) {
        this.dictionary = dictionary;
        this.allocator = allocator;
        BaseListVector dictVector = (BaseListVector)dictionary.getVector();
        this.hashTable = new DictionaryHashTable(this.getDataVector(dictVector), hasher);
    }

    private FieldVector getDataVector(BaseListVector vector) {
        return vector.getChildrenFromFields().get(0);
    }

    private BaseListVector cloneVector(BaseListVector vector) {
        FieldType fieldType = vector.getField().getFieldType();
        BaseListVector cloned = (BaseListVector)fieldType.createNewSingleVector(vector.getField().getName(), this.allocator, null);
        ArrowFieldNode fieldNode = new ArrowFieldNode(vector.getValueCount(), vector.getNullCount());
        cloned.loadFieldBuffers(fieldNode, vector.getFieldBuffers());
        return cloned;
    }

    public BaseListVector encodeListSubField(BaseListVector vector) {
        int valueCount = vector.getValueCount();
        FieldType indexFieldType = new FieldType(vector.getField().isNullable(), this.dictionary.getEncoding().getIndexType(), this.dictionary.getEncoding(), vector.getField().getMetadata());
        Field valueField = new Field(vector.getField().getName(), indexFieldType, null);
        BaseListVector encoded = this.cloneVector(vector);
        encoded.initializeChildrenFromFields(Collections.singletonList(valueField));
        BaseIntVector indices = (BaseIntVector)this.getDataVector(encoded);
        FieldVector dataVector = this.getDataVector(vector);
        for (int i = 0; i < valueCount; ++i) {
            if (vector.isNull(i)) continue;
            int start = vector.getElementStartIndex(i);
            int end = vector.getElementEndIndex(i);
            DictionaryEncoder.buildIndexVector(dataVector, indices, this.hashTable, start, end);
        }
        return encoded;
    }

    public BaseListVector decodeListSubField(BaseListVector vector) {
        int valueCount = vector.getValueCount();
        BaseListVector dictionaryVector = (BaseListVector)this.dictionary.getVector();
        int dictionaryValueCount = this.getDataVector(dictionaryVector).getValueCount();
        BaseListVector decoded = this.cloneVector(vector);
        Field dataVectorField = this.getDataVector(dictionaryVector).getField();
        decoded.initializeChildrenFromFields(Collections.singletonList(dataVectorField));
        FieldVector dataVector = this.getDataVector(decoded);
        TransferPair transfer = this.getDataVector(dictionaryVector).makeTransferPair(dataVector);
        BaseIntVector indices = (BaseIntVector)this.getDataVector(vector);
        for (int i = 0; i < valueCount; ++i) {
            if (vector.isNull(i)) continue;
            int start = vector.getElementStartIndex(i);
            int end = vector.getElementEndIndex(i);
            DictionaryEncoder.retrieveIndexVector(indices, transfer, dictionaryValueCount, start, end);
        }
        return decoded;
    }
}

