/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex.impl;

import cdjd.com.dremio.exec.exception.SchemaChangeException;
import cdjd.com.dremio.sabot.op.scan.OutputMutator;
import cdjd.com.google.common.base.Function;
import cdjd.com.google.common.collect.Iterables;
import cdjd.com.google.common.collect.Lists;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.RootAllocator;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.NonNullableStructVector;
import cdjd.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import cdjd.org.apache.arrow.vector.complex.impl.SingleStructWriter;
import cdjd.org.apache.arrow.vector.complex.writer.BaseWriter;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.CallBack;
import java.util.List;
import javax.annotation.Nullable;

public class VectorContainerWriter
extends AbstractFieldWriter
implements BaseWriter.ComplexWriter {
    private final SingleStructWriter structRoot;
    private final SpecialStructVector structVector;
    private final OutputMutator mutator;
    private BufferAllocator allocator;

    public VectorContainerWriter(OutputMutator mutator) {
        this.mutator = mutator;
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.structVector = new SpecialStructVector(this.allocator, mutator.getCallBack());
        this.structRoot = new SingleStructWriter(this.structVector);
    }

    @Override
    public Field getField() {
        return this.structVector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.structRoot.getValueCapacity();
    }

    public void setInitialCapacity(int initialCapacity) {
        this.structRoot.setInitialCapacity(initialCapacity);
    }

    public NonNullableStructVector getStructVector() {
        return this.structVector;
    }

    @Override
    public void reset() {
        this.setPosition(0);
    }

    @Override
    public void close() throws Exception {
        this.clear();
        this.structRoot.close();
        this.structVector.close();
    }

    @Override
    public void clear() {
        this.structRoot.clear();
    }

    public SingleStructWriter getWriter() {
        return this.structRoot;
    }

    @Override
    public void setValueCount(int count) {
        this.structRoot.setValueCount(count);
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        this.structRoot.setPosition(index);
    }

    @Override
    public void allocate() {
        this.structRoot.allocate();
    }

    @Override
    public BaseWriter.StructWriter rootAsStruct() {
        return this.structRoot;
    }

    @Override
    public BaseWriter.ListWriter rootAsList() {
        throw new UnsupportedOperationException("Dremio doesn't support objects whose first level is a scalar or array.  Objects must start as maps.");
    }

    private class SpecialStructVector
    extends NonNullableStructVector {
        public SpecialStructVector(BufferAllocator allocator, CallBack callback) {
            super("", allocator, new FieldType(false, ArrowType.Struct.INSTANCE, null, null), callback);
        }

        @Override
        public List<FieldVector> getChildren() {
            return Lists.newArrayList(Iterables.transform(VectorContainerWriter.this.mutator.getVectors(), new Function<ValueVector, FieldVector>(){

                @Override
                @Nullable
                public FieldVector apply(@Nullable ValueVector input) {
                    return (FieldVector)input;
                }
            }));
        }

        @Override
        public <T extends FieldVector> T addOrGet(String childName, FieldType fieldType, Class<T> clazz) {
            try {
                Field field = new Field(childName, fieldType, null);
                FieldVector v = (FieldVector)VectorContainerWriter.this.mutator.addField(field, clazz);
                this.putChild(childName, v);
                return (T)((FieldVector)this.typeify(v, clazz));
            }
            catch (SchemaChangeException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public <T extends FieldVector> T getChild(String name, Class<T> clazz) {
            ValueVector v = VectorContainerWriter.this.mutator.getVector(name.toLowerCase());
            if (v == null) {
                return null;
            }
            return (T)((FieldVector)this.typeify(v, clazz));
        }
    }
}

