/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex.impl;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.NullVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.AbstractStructVector;
import cdjd.org.apache.arrow.vector.complex.FixedSizeListVector;
import cdjd.org.apache.arrow.vector.complex.ListVector;
import cdjd.org.apache.arrow.vector.complex.StructVector;
import cdjd.org.apache.arrow.vector.complex.UnionVector;
import cdjd.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import cdjd.org.apache.arrow.vector.complex.impl.AbstractPromotableFieldWriter;
import cdjd.org.apache.arrow.vector.complex.impl.NullableStructWriterFactory;
import cdjd.org.apache.arrow.vector.complex.impl.UnionListWriter;
import cdjd.org.apache.arrow.vector.complex.impl.UnionWriter;
import cdjd.org.apache.arrow.vector.complex.writer.FieldWriter;
import cdjd.org.apache.arrow.vector.holders.DecimalHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.math.BigDecimal;

public class PromotableWriter
extends AbstractPromotableFieldWriter {
    private final AbstractStructVector parentContainer;
    private final ListVector listVector;
    private final FixedSizeListVector fixedListVector;
    private final NullableStructWriterFactory nullableStructWriterFactory;
    private int position;
    private static final int MAX_DECIMAL_PRECISION = 38;
    private Types.MinorType type;
    private ValueVector vector;
    private UnionVector unionVector;
    private State state;
    private FieldWriter writer;

    public PromotableWriter(ValueVector v, AbstractStructVector parentContainer) {
        this(v, parentContainer, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, AbstractStructVector parentContainer, NullableStructWriterFactory nullableStructWriterFactory) {
        this.parentContainer = parentContainer;
        this.listVector = null;
        this.fixedListVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, ListVector listVector) {
        this(v, listVector, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, FixedSizeListVector fixedListVector) {
        this(v, fixedListVector, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, ListVector listVector, NullableStructWriterFactory nullableStructWriterFactory) {
        this.listVector = listVector;
        this.parentContainer = null;
        this.fixedListVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, FixedSizeListVector fixedListVector, NullableStructWriterFactory nullableStructWriterFactory) {
        this.fixedListVector = fixedListVector;
        this.parentContainer = null;
        this.listVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    private void init(ValueVector v) {
        if (v instanceof UnionVector) {
            this.state = State.UNION;
            this.unionVector = (UnionVector)v;
            this.writer = new UnionWriter(this.unionVector, this.nullableStructWriterFactory);
        } else if (v instanceof NullVector) {
            this.state = State.UNTYPED;
        } else {
            this.setWriter(v);
        }
    }

    @Override
    public void setAddVectorAsNullable(boolean nullable) {
        super.setAddVectorAsNullable(nullable);
        if (this.writer instanceof AbstractFieldWriter) {
            ((AbstractFieldWriter)this.writer).setAddVectorAsNullable(nullable);
        }
    }

    private void setWriter(ValueVector v) {
        this.state = State.SINGLE;
        this.vector = v;
        this.type = v.getMinorType();
        switch (this.type) {
            case STRUCT: {
                this.writer = this.nullableStructWriterFactory.build((StructVector)this.vector);
                break;
            }
            case LIST: {
                this.writer = new UnionListWriter((ListVector)this.vector, this.nullableStructWriterFactory);
                break;
            }
            case UNION: {
                this.writer = new UnionWriter((UnionVector)this.vector, this.nullableStructWriterFactory);
                break;
            }
            default: {
                this.writer = this.type.getNewFieldWriter(this.vector);
            }
        }
    }

    @Override
    public void writeNull() {
        this.setPosition(this.idx() + 1);
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        FieldWriter w = this.getWriter();
        if (w == null) {
            this.position = index;
        } else {
            w.setPosition(index);
        }
    }

    @Override
    protected FieldWriter getWriter(Types.MinorType type) {
        return this.getWriter(type, null);
    }

    protected FieldWriter getWriter(Types.MinorType type, ArrowType arrowType) {
        if (this.state == State.UNION) {
            if (type == Types.MinorType.DECIMAL) {
                ((UnionWriter)this.writer).getWriter(type, arrowType);
            } else {
                ((UnionWriter)this.writer).getWriter(type);
            }
        } else if (this.state == State.UNTYPED) {
            if (type == null) {
                return null;
            }
            if (arrowType == null) {
                arrowType = type.getType();
            }
            FieldType fieldType = new FieldType(this.addVectorAsNullable, arrowType, null, null);
            Object v = this.listVector != null ? this.listVector.addOrGetVector(fieldType).getVector() : this.fixedListVector.addOrGetVector(fieldType).getVector();
            v.allocateNew();
            this.setWriter((ValueVector)v);
            this.writer.setPosition(this.position);
        } else if (type != this.type) {
            this.promoteToUnion();
            if (type == Types.MinorType.DECIMAL) {
                ((UnionWriter)this.writer).getWriter(type, arrowType);
            } else {
                ((UnionWriter)this.writer).getWriter(type);
            }
        }
        return this.writer;
    }

    @Override
    public boolean isEmptyStruct() {
        return this.writer.isEmptyStruct();
    }

    @Override
    protected FieldWriter getWriter() {
        return this.writer;
    }

    private FieldWriter promoteToUnion() {
        String name = this.vector.getField().getName();
        TransferPair tp = this.vector.getTransferPair(this.vector.getMinorType().name().toLowerCase(), this.vector.getAllocator());
        tp.transfer();
        if (this.parentContainer != null) {
            this.unionVector = this.parentContainer.addOrGetUnion(name);
            this.unionVector.allocateNew();
        } else if (this.listVector != null) {
            this.unionVector = this.listVector.promoteToUnion();
        } else if (this.fixedListVector != null) {
            this.unionVector = this.fixedListVector.promoteToUnion();
        }
        this.unionVector.addVector((FieldVector)tp.getTo());
        this.writer = new UnionWriter(this.unionVector, this.nullableStructWriterFactory);
        this.writer.setPosition(this.idx());
        for (int i = 0; i <= this.idx(); ++i) {
            this.unionVector.setType(i, this.vector.getMinorType());
        }
        this.vector = null;
        this.state = State.UNION;
        return this.writer;
    }

    @Override
    public void write(DecimalHolder holder) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, holder.scale)).write(holder);
    }

    @Override
    public void writeDecimal(int start, ArrowBuf buffer, ArrowType arrowType) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, ((ArrowType.Decimal)arrowType).getScale())).writeDecimal(start, buffer, arrowType);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, value.scale())).writeDecimal(value);
    }

    @Override
    public void writeBigEndianBytesToDecimal(byte[] value, ArrowType arrowType) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, ((ArrowType.Decimal)arrowType).getScale())).writeBigEndianBytesToDecimal(value, arrowType);
    }

    @Override
    public void allocate() {
        this.getWriter().allocate();
    }

    @Override
    public void clear() {
        this.getWriter().clear();
    }

    @Override
    public Field getField() {
        return this.getWriter().getField();
    }

    @Override
    public int getValueCapacity() {
        return this.getWriter().getValueCapacity();
    }

    @Override
    public void close() throws Exception {
        this.getWriter().close();
    }

    private static enum State {
        UNTYPED,
        SINGLE,
        UNION;

    }
}

