/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex.impl;

import cdjd.org.apache.arrow.vector.complex.impl.UnionMapReader;
import cdjd.org.apache.arrow.vector.complex.impl.UnionMapWriter;
import cdjd.org.apache.arrow.vector.complex.reader.FieldReader;
import cdjd.org.apache.arrow.vector.complex.writer.BaseWriter;
import cdjd.org.apache.arrow.vector.complex.writer.FieldWriter;
import cdjd.org.apache.arrow.vector.holders.NullableBigIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableBitHolder;
import cdjd.org.apache.arrow.vector.holders.NullableDateDayHolder;
import cdjd.org.apache.arrow.vector.holders.NullableDateMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableDecimalHolder;
import cdjd.org.apache.arrow.vector.holders.NullableFloat4Holder;
import cdjd.org.apache.arrow.vector.holders.NullableFloat8Holder;
import cdjd.org.apache.arrow.vector.holders.NullableIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import cdjd.org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import cdjd.org.apache.arrow.vector.holders.NullableLargeVarBinaryHolder;
import cdjd.org.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import cdjd.org.apache.arrow.vector.holders.NullableSmallIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeMicroHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeNanoHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeSecHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTinyIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt1Holder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt2Holder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt4Holder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt8Holder;
import cdjd.org.apache.arrow.vector.holders.NullableVarBinaryHolder;
import cdjd.org.apache.arrow.vector.holders.NullableVarCharHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;

public class ComplexCopier {
    public static void copy(FieldReader input, FieldWriter output) {
        ComplexCopier.writeValue(input, output);
    }

    private static void writeValue(FieldReader reader, FieldWriter writer) {
        Types.MinorType mt = reader.getMinorType();
        switch (mt) {
            case LIST: 
            case FIXED_SIZE_LIST: {
                if (reader.isSet()) {
                    writer.startList();
                    while (reader.next()) {
                        FieldReader childReader = reader.reader();
                        FieldWriter childWriter = ComplexCopier.getListWriterForReader(childReader, writer);
                        if (childReader.isSet()) {
                            ComplexCopier.writeValue(childReader, childWriter);
                            continue;
                        }
                        childWriter.writeNull();
                    }
                    writer.endList();
                    break;
                }
                writer.writeNull();
                break;
            }
            case MAP: {
                if (reader.isSet()) {
                    UnionMapWriter mapWriter = (UnionMapWriter)writer;
                    UnionMapReader mapReader = (UnionMapReader)reader;
                    mapWriter.startMap();
                    while (mapReader.next()) {
                        FieldReader structReader = reader.reader();
                        UnionMapWriter structWriter = (UnionMapWriter)writer.struct();
                        if (structReader.isSet()) {
                            mapWriter.startEntry();
                            ComplexCopier.writeValue(mapReader.key(), ComplexCopier.getStructWriterForReader(mapReader.key(), structWriter.key(), "key"));
                            ComplexCopier.writeValue(mapReader.value(), ComplexCopier.getStructWriterForReader(mapReader.value(), structWriter.value(), "value"));
                            mapWriter.endEntry();
                            continue;
                        }
                        structWriter.writeNull();
                    }
                    mapWriter.endMap();
                    break;
                }
                writer.writeNull();
                break;
            }
            case STRUCT: {
                if (reader.isSet()) {
                    writer.start();
                    for (String name : reader) {
                        FieldReader childReader = reader.reader(name);
                        if (childReader.getMinorType() == Types.MinorType.NULL) continue;
                        FieldWriter childWriter = ComplexCopier.getStructWriterForReader(childReader, writer, name);
                        if (childReader.isSet()) {
                            ComplexCopier.writeValue(childReader, childWriter);
                            continue;
                        }
                        childWriter.writeNull();
                    }
                    writer.end();
                    break;
                }
                writer.writeNull();
                break;
            }
            case TINYINT: {
                if (reader.isSet()) {
                    NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
                    reader.read(tinyIntHolder);
                    if (tinyIntHolder.isSet != 1) break;
                    writer.writeTinyInt(tinyIntHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case UINT1: {
                if (reader.isSet()) {
                    NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
                    reader.read(uInt1Holder);
                    if (uInt1Holder.isSet != 1) break;
                    writer.writeUInt1(uInt1Holder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case UINT2: {
                if (reader.isSet()) {
                    NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
                    reader.read(uInt2Holder);
                    if (uInt2Holder.isSet != 1) break;
                    writer.writeUInt2(uInt2Holder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case SMALLINT: {
                if (reader.isSet()) {
                    NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
                    reader.read(smallIntHolder);
                    if (smallIntHolder.isSet != 1) break;
                    writer.writeSmallInt(smallIntHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case INT: {
                if (reader.isSet()) {
                    NullableIntHolder intHolder = new NullableIntHolder();
                    reader.read(intHolder);
                    if (intHolder.isSet != 1) break;
                    writer.writeInt(intHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case UINT4: {
                if (reader.isSet()) {
                    NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
                    reader.read(uInt4Holder);
                    if (uInt4Holder.isSet != 1) break;
                    writer.writeUInt4(uInt4Holder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case FLOAT4: {
                if (reader.isSet()) {
                    NullableFloat4Holder float4Holder = new NullableFloat4Holder();
                    reader.read(float4Holder);
                    if (float4Holder.isSet != 1) break;
                    writer.writeFloat4(float4Holder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case DATEDAY: {
                if (reader.isSet()) {
                    NullableDateDayHolder dateDayHolder = new NullableDateDayHolder();
                    reader.read(dateDayHolder);
                    if (dateDayHolder.isSet != 1) break;
                    writer.writeDateDay(dateDayHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case INTERVALYEAR: {
                if (reader.isSet()) {
                    NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
                    reader.read(intervalYearHolder);
                    if (intervalYearHolder.isSet != 1) break;
                    writer.writeIntervalYear(intervalYearHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMESEC: {
                if (reader.isSet()) {
                    NullableTimeSecHolder timeSecHolder = new NullableTimeSecHolder();
                    reader.read(timeSecHolder);
                    if (timeSecHolder.isSet != 1) break;
                    writer.writeTimeSec(timeSecHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMEMILLI: {
                if (reader.isSet()) {
                    NullableTimeMilliHolder timeMilliHolder = new NullableTimeMilliHolder();
                    reader.read(timeMilliHolder);
                    if (timeMilliHolder.isSet != 1) break;
                    writer.writeTimeMilli(timeMilliHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case BIGINT: {
                if (reader.isSet()) {
                    NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
                    reader.read(bigIntHolder);
                    if (bigIntHolder.isSet != 1) break;
                    writer.writeBigInt(bigIntHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case UINT8: {
                if (reader.isSet()) {
                    NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
                    reader.read(uInt8Holder);
                    if (uInt8Holder.isSet != 1) break;
                    writer.writeUInt8(uInt8Holder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case FLOAT8: {
                if (reader.isSet()) {
                    NullableFloat8Holder float8Holder = new NullableFloat8Holder();
                    reader.read(float8Holder);
                    if (float8Holder.isSet != 1) break;
                    writer.writeFloat8(float8Holder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case DATEMILLI: {
                if (reader.isSet()) {
                    NullableDateMilliHolder dateMilliHolder = new NullableDateMilliHolder();
                    reader.read(dateMilliHolder);
                    if (dateMilliHolder.isSet != 1) break;
                    writer.writeDateMilli(dateMilliHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMESTAMPSEC: {
                if (reader.isSet()) {
                    NullableTimeStampSecHolder timeStampSecHolder = new NullableTimeStampSecHolder();
                    reader.read(timeStampSecHolder);
                    if (timeStampSecHolder.isSet != 1) break;
                    writer.writeTimeStampSec(timeStampSecHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMESTAMPMILLI: {
                if (reader.isSet()) {
                    NullableTimeStampMilliHolder timeStampMilliHolder = new NullableTimeStampMilliHolder();
                    reader.read(timeStampMilliHolder);
                    if (timeStampMilliHolder.isSet != 1) break;
                    writer.writeTimeStampMilli(timeStampMilliHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMESTAMPMICRO: {
                if (reader.isSet()) {
                    NullableTimeStampMicroHolder timeStampMicroHolder = new NullableTimeStampMicroHolder();
                    reader.read(timeStampMicroHolder);
                    if (timeStampMicroHolder.isSet != 1) break;
                    writer.writeTimeStampMicro(timeStampMicroHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMESTAMPNANO: {
                if (reader.isSet()) {
                    NullableTimeStampNanoHolder timeStampNanoHolder = new NullableTimeStampNanoHolder();
                    reader.read(timeStampNanoHolder);
                    if (timeStampNanoHolder.isSet != 1) break;
                    writer.writeTimeStampNano(timeStampNanoHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMEMICRO: {
                if (reader.isSet()) {
                    NullableTimeMicroHolder timeMicroHolder = new NullableTimeMicroHolder();
                    reader.read(timeMicroHolder);
                    if (timeMicroHolder.isSet != 1) break;
                    writer.writeTimeMicro(timeMicroHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case TIMENANO: {
                if (reader.isSet()) {
                    NullableTimeNanoHolder timeNanoHolder = new NullableTimeNanoHolder();
                    reader.read(timeNanoHolder);
                    if (timeNanoHolder.isSet != 1) break;
                    writer.writeTimeNano(timeNanoHolder.value);
                    break;
                }
                writer.writeNull();
                break;
            }
            case INTERVALDAY: {
                if (reader.isSet()) {
                    NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                    reader.read(intervalDayHolder);
                    if (intervalDayHolder.isSet != 1) break;
                    writer.writeIntervalDay(intervalDayHolder.days, intervalDayHolder.milliseconds);
                    break;
                }
                writer.writeNull();
                break;
            }
            case DECIMAL: {
                if (reader.isSet()) {
                    NullableDecimalHolder decimalHolder = new NullableDecimalHolder();
                    reader.read(decimalHolder);
                    if (decimalHolder.isSet != 1) break;
                    writer.writeDecimal(decimalHolder.start, decimalHolder.buffer, new ArrowType.Decimal(decimalHolder.precision, decimalHolder.scale));
                    break;
                }
                writer.writeNull();
                break;
            }
            case VARBINARY: {
                if (reader.isSet()) {
                    NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
                    reader.read(varBinaryHolder);
                    if (varBinaryHolder.isSet != 1) break;
                    writer.writeVarBinary(varBinaryHolder.start, varBinaryHolder.end, varBinaryHolder.buffer);
                    break;
                }
                writer.writeNull();
                break;
            }
            case VARCHAR: {
                if (reader.isSet()) {
                    NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
                    reader.read(varCharHolder);
                    if (varCharHolder.isSet != 1) break;
                    writer.writeVarChar(varCharHolder.start, varCharHolder.end, varCharHolder.buffer);
                    break;
                }
                writer.writeNull();
                break;
            }
            case LARGEVARCHAR: {
                if (reader.isSet()) {
                    NullableLargeVarCharHolder largeVarCharHolder = new NullableLargeVarCharHolder();
                    reader.read(largeVarCharHolder);
                    if (largeVarCharHolder.isSet != 1) break;
                    writer.writeLargeVarChar(largeVarCharHolder.start, largeVarCharHolder.end, largeVarCharHolder.buffer);
                    break;
                }
                writer.writeNull();
                break;
            }
            case LARGEVARBINARY: {
                if (reader.isSet()) {
                    NullableLargeVarBinaryHolder largeVarBinaryHolder = new NullableLargeVarBinaryHolder();
                    reader.read(largeVarBinaryHolder);
                    if (largeVarBinaryHolder.isSet != 1) break;
                    writer.writeLargeVarBinary(largeVarBinaryHolder.start, largeVarBinaryHolder.end, largeVarBinaryHolder.buffer);
                    break;
                }
                writer.writeNull();
                break;
            }
            case BIT: {
                if (reader.isSet()) {
                    NullableBitHolder bitHolder = new NullableBitHolder();
                    reader.read(bitHolder);
                    if (bitHolder.isSet != 1) break;
                    writer.writeBit(bitHolder.value);
                    break;
                }
                writer.writeNull();
            }
        }
    }

    private static FieldWriter getStructWriterForReader(FieldReader reader, BaseWriter.StructWriter writer, String name) {
        switch (reader.getMinorType()) {
            case TINYINT: {
                return (FieldWriter)writer.tinyInt(name);
            }
            case UINT1: {
                return (FieldWriter)writer.uInt1(name);
            }
            case UINT2: {
                return (FieldWriter)writer.uInt2(name);
            }
            case SMALLINT: {
                return (FieldWriter)writer.smallInt(name);
            }
            case INT: {
                return (FieldWriter)writer.integer(name);
            }
            case UINT4: {
                return (FieldWriter)writer.uInt4(name);
            }
            case FLOAT4: {
                return (FieldWriter)writer.float4(name);
            }
            case DATEDAY: {
                return (FieldWriter)writer.dateDay(name);
            }
            case INTERVALYEAR: {
                return (FieldWriter)writer.intervalYear(name);
            }
            case TIMESEC: {
                return (FieldWriter)writer.timeSec(name);
            }
            case TIMEMILLI: {
                return (FieldWriter)writer.timeMilli(name);
            }
            case BIGINT: {
                return (FieldWriter)writer.bigInt(name);
            }
            case UINT8: {
                return (FieldWriter)writer.uInt8(name);
            }
            case FLOAT8: {
                return (FieldWriter)writer.float8(name);
            }
            case DATEMILLI: {
                return (FieldWriter)writer.dateMilli(name);
            }
            case TIMESTAMPSEC: {
                return (FieldWriter)writer.timeStampSec(name);
            }
            case TIMESTAMPMILLI: {
                return (FieldWriter)writer.timeStampMilli(name);
            }
            case TIMESTAMPMICRO: {
                return (FieldWriter)writer.timeStampMicro(name);
            }
            case TIMESTAMPNANO: {
                return (FieldWriter)writer.timeStampNano(name);
            }
            case TIMEMICRO: {
                return (FieldWriter)writer.timeMicro(name);
            }
            case TIMENANO: {
                return (FieldWriter)writer.timeNano(name);
            }
            case INTERVALDAY: {
                return (FieldWriter)writer.intervalDay(name);
            }
            case DECIMAL: {
                if (reader.getField().getType() instanceof ArrowType.Decimal) {
                    ArrowType.Decimal type = (ArrowType.Decimal)reader.getField().getType();
                    return (FieldWriter)writer.decimal(name, type.getScale(), type.getPrecision());
                }
                return (FieldWriter)writer.decimal(name);
            }
            case VARBINARY: {
                return (FieldWriter)writer.varBinary(name);
            }
            case VARCHAR: {
                return (FieldWriter)writer.varChar(name);
            }
            case LARGEVARCHAR: {
                return (FieldWriter)writer.largeVarChar(name);
            }
            case LARGEVARBINARY: {
                return (FieldWriter)writer.largeVarBinary(name);
            }
            case BIT: {
                return (FieldWriter)writer.bit(name);
            }
            case STRUCT: {
                return (FieldWriter)writer.struct(name);
            }
            case LIST: 
            case FIXED_SIZE_LIST: 
            case MAP: {
                return (FieldWriter)writer.list(name);
            }
        }
        throw new UnsupportedOperationException(reader.getMinorType().toString());
    }

    private static FieldWriter getListWriterForReader(FieldReader reader, BaseWriter.ListWriter writer) {
        switch (reader.getMinorType()) {
            case TINYINT: {
                return (FieldWriter)writer.tinyInt();
            }
            case UINT1: {
                return (FieldWriter)writer.uInt1();
            }
            case UINT2: {
                return (FieldWriter)writer.uInt2();
            }
            case SMALLINT: {
                return (FieldWriter)writer.smallInt();
            }
            case INT: {
                return (FieldWriter)writer.integer();
            }
            case UINT4: {
                return (FieldWriter)writer.uInt4();
            }
            case FLOAT4: {
                return (FieldWriter)writer.float4();
            }
            case DATEDAY: {
                return (FieldWriter)writer.dateDay();
            }
            case INTERVALYEAR: {
                return (FieldWriter)writer.intervalYear();
            }
            case TIMESEC: {
                return (FieldWriter)writer.timeSec();
            }
            case TIMEMILLI: {
                return (FieldWriter)writer.timeMilli();
            }
            case BIGINT: {
                return (FieldWriter)writer.bigInt();
            }
            case UINT8: {
                return (FieldWriter)writer.uInt8();
            }
            case FLOAT8: {
                return (FieldWriter)writer.float8();
            }
            case DATEMILLI: {
                return (FieldWriter)writer.dateMilli();
            }
            case TIMESTAMPSEC: {
                return (FieldWriter)writer.timeStampSec();
            }
            case TIMESTAMPMILLI: {
                return (FieldWriter)writer.timeStampMilli();
            }
            case TIMESTAMPMICRO: {
                return (FieldWriter)writer.timeStampMicro();
            }
            case TIMESTAMPNANO: {
                return (FieldWriter)writer.timeStampNano();
            }
            case TIMEMICRO: {
                return (FieldWriter)writer.timeMicro();
            }
            case TIMENANO: {
                return (FieldWriter)writer.timeNano();
            }
            case INTERVALDAY: {
                return (FieldWriter)writer.intervalDay();
            }
            case DECIMAL: {
                return (FieldWriter)writer.decimal();
            }
            case VARBINARY: {
                return (FieldWriter)writer.varBinary();
            }
            case VARCHAR: {
                return (FieldWriter)writer.varChar();
            }
            case LARGEVARCHAR: {
                return (FieldWriter)writer.largeVarChar();
            }
            case LARGEVARBINARY: {
                return (FieldWriter)writer.largeVarBinary();
            }
            case BIT: {
                return (FieldWriter)writer.bit();
            }
            case STRUCT: {
                return (FieldWriter)writer.struct();
            }
            case LIST: 
            case FIXED_SIZE_LIST: 
            case MAP: 
            case NULL: {
                return (FieldWriter)writer.list();
            }
        }
        throw new UnsupportedOperationException(reader.getMinorType().toString());
    }
}

