/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.io.netty.util.internal.PlatformDependent;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.BaseFixedWidthVector;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.NullCheckingForGet;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.impl.DecimalReaderImpl;
import cdjd.org.apache.arrow.vector.complex.reader.FieldReader;
import cdjd.org.apache.arrow.vector.holders.DecimalHolder;
import cdjd.org.apache.arrow.vector.holders.NullableDecimalHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.DecimalUtility;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.math.BigDecimal;

public final class DecimalVector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 16;
    private final FieldReader reader;
    private final int precision;
    private final int scale;

    public DecimalVector(String name, BufferAllocator allocator, int precision, int scale) {
        this(name, FieldType.nullable(new ArrowType.Decimal(precision, scale)), allocator);
    }

    public DecimalVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public DecimalVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 16);
        ArrowType.Decimal arrowType = (ArrowType.Decimal)field.getFieldType().getType();
        this.reader = new DecimalReaderImpl(this);
        this.precision = arrowType.getPrecision();
        this.scale = arrowType.getScale();
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DECIMAL;
    }

    public ArrowBuf get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.slice((long)index * 16L, 16L);
    }

    public void get(int index, NullableDecimalHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.buffer = this.valueBuffer;
        holder.precision = this.precision;
        holder.scale = this.scale;
        holder.start = index * 16;
    }

    @Override
    public BigDecimal getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromArrowBuf(this.valueBuffer, index, this.scale);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void set(int index, ArrowBuf buffer) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.valueBuffer.setBytes((long)index * 16L, buffer, 0L, 16L);
    }

    public void setBigEndian(int index, byte[] value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        int length = value.length;
        this.valueBuffer.checkBytes((long)index * 16L, (long)(index + 1) * 16L);
        long outAddress = this.valueBuffer.memoryAddress() + (long)index * 16L;
        for (int byteIdx = 0; byteIdx < length; ++byteIdx) {
            PlatformDependent.putByte(outAddress + (long)byteIdx, value[length - 1 - byteIdx]);
        }
        if (length == 16) {
            return;
        }
        if (length == 0) {
            PlatformDependent.setMemory(outAddress, 16L, (byte)0);
        } else if (length < 16) {
            byte pad = (byte)(value[0] < 0 ? 255 : 0);
            PlatformDependent.setMemory(outAddress + (long)length, 16 - length, pad);
        } else {
            throw new IllegalArgumentException("Invalid decimal value length. Valid length in [1 - 16], got " + length);
        }
    }

    public void set(int index, int start, ArrowBuf buffer) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.valueBuffer.setBytes((long)index * 16L, buffer, (long)start, 16L);
    }

    public void setSafe(int index, int start, ArrowBuf buffer, int length) {
        this.handleSafe(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        buffer.checkBytes(start, start + length);
        this.valueBuffer.checkBytes((long)index * 16L, (long)(index + 1) * 16L);
        long inAddress = buffer.memoryAddress() + (long)start;
        long outAddress = this.valueBuffer.memoryAddress() + (long)index * 16L;
        PlatformDependent.copyMemory(inAddress, outAddress, length);
        if (length < 16) {
            byte msb = PlatformDependent.getByte(inAddress + (long)length - 1L);
            byte pad = (byte)(msb < 0 ? 255 : 0);
            PlatformDependent.setMemory(outAddress + (long)length, 16 - length, pad);
        }
    }

    public void setBigEndianSafe(int index, int start, ArrowBuf buffer, int length) {
        this.handleSafe(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        buffer.checkBytes(start, start + length);
        this.valueBuffer.checkBytes((long)index * 16L, (long)(index + 1) * 16L);
        long inAddress = buffer.memoryAddress() + (long)start;
        long outAddress = this.valueBuffer.memoryAddress() + (long)index * 16L;
        for (int byteIdx = 0; byteIdx < length; ++byteIdx) {
            byte val = PlatformDependent.getByte(inAddress + (long)length - 1L - (long)byteIdx);
            PlatformDependent.putByte(outAddress + (long)byteIdx, val);
        }
        if (length < 16) {
            byte msb = PlatformDependent.getByte(inAddress);
            byte pad = (byte)(msb < 0 ? 255 : 0);
            PlatformDependent.setMemory(outAddress + (long)length, 16 - length, pad);
        }
    }

    public void set(int index, BigDecimal value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        DecimalUtility.checkPrecisionAndScale(value, this.precision, this.scale);
        DecimalUtility.writeBigDecimalToArrowBuf(value, this.valueBuffer, index);
    }

    public void set(int index, long value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        DecimalUtility.writeLongToArrowBuf(value, this.valueBuffer, index);
    }

    public void set(int index, NullableDecimalHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.valueBuffer.setBytes((long)index * 16L, holder.buffer, (long)holder.start, 16L);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, DecimalHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.valueBuffer.setBytes((long)index * 16L, holder.buffer, (long)holder.start, 16L);
    }

    public void setSafe(int index, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, buffer);
    }

    public void setBigEndianSafe(int index, byte[] value) {
        this.handleSafe(index);
        this.setBigEndian(index, value);
    }

    public void setSafe(int index, int start, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, start, buffer);
    }

    public void setSafe(int index, BigDecimal value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, long value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableDecimalHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, DecimalHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, int start, ArrowBuf buffer) {
        if (isSet > 0) {
            this.set(index, start, buffer);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, int start, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, isSet, start, buffer);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((DecimalVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        DecimalVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new DecimalVector(ref, allocator, DecimalVector.this.precision, DecimalVector.this.scale);
        }

        public TransferImpl(DecimalVector to) {
            this.to = to;
        }

        @Override
        public DecimalVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            DecimalVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            DecimalVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, DecimalVector.this);
        }
    }
}

