/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.io.netty.util.internal.PlatformDependent;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.util.ArrowBufPointer;
import cdjd.org.apache.arrow.memory.util.ByteFunctionHelpers;
import cdjd.org.apache.arrow.memory.util.LargeMemoryUtil;
import cdjd.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BaseValueVector;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.BufferBacked;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.FixedWidthVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.VectorDefinitionSetter;
import cdjd.org.apache.arrow.vector.compare.VectorVisitor;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.util.CallBack;
import cdjd.org.apache.arrow.vector.util.OversizedAllocationException;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseFixedWidthVector
extends BaseValueVector
implements FixedWidthVector,
FieldVector,
VectorDefinitionSetter {
    private final int typeWidth;
    protected int lastValueCapacity;
    protected final Field field;
    private int allocationMonitor;
    protected ArrowBuf validityBuffer;
    protected ArrowBuf valueBuffer;
    protected int valueCount;

    public BaseFixedWidthVector(Field field, BufferAllocator allocator, int typeWidth) {
        super(allocator);
        this.typeWidth = typeWidth;
        this.field = field;
        this.valueCount = 0;
        this.allocationMonitor = 0;
        this.validityBuffer = allocator.getEmpty();
        this.valueBuffer = allocator.getEmpty();
        this.lastValueCapacity = 3970;
    }

    public int getTypeWidth() {
        return this.typeWidth;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        return this.valueBuffer.memoryAddress();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException("not supported for fixed-width vectors");
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        return this.valueBuffer;
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException("not supported for fixed-width vectors");
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        this.computeAndCheckBufferSize(valueCount);
        this.lastValueCapacity = valueCount;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.getValueBufferValueCapacity(), this.getValidityBufferValueCapacity());
    }

    private int getValueBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.valueBuffer.capacity() / (long)this.typeWidth);
    }

    private int getValidityBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.validityBuffer.capacity() * 8L);
    }

    @Override
    public void zeroVector() {
        this.initValidityBuffer();
        this.initValueBuffer();
    }

    private void initValidityBuffer() {
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    private void initValueBuffer() {
        this.valueBuffer.setZero(0L, this.valueBuffer.capacity());
    }

    @Override
    public void reset() {
        this.valueCount = 0;
        this.zeroVector();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.valueBuffer = this.releaseBuffer(this.valueBuffer);
    }

    protected void incrementAllocationMonitor() {
        if (this.allocationMonitor < 0) {
            this.allocationMonitor = 0;
        }
        ++this.allocationMonitor;
    }

    protected void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    @Override
    public void allocateNew() {
        this.allocateNew(this.lastValueCapacity);
    }

    @Override
    public boolean allocateNewSafe() {
        try {
            this.allocateNew(this.lastValueCapacity);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void allocateNew(int valueCount) {
        this.computeAndCheckBufferSize(valueCount);
        this.clear();
        try {
            this.allocateBytes(valueCount);
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    private long computeAndCheckBufferSize(int valueCount) {
        long size = this.computeCombinedBufferSize(valueCount, this.typeWidth);
        if (size > MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Memory required for vector capacity " + valueCount + " is (" + size + "), which is more than max allowed (" + MAX_ALLOCATION_SIZE + ")");
        }
        return size;
    }

    private void allocateBytes(int valueCount) {
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(valueCount, this.typeWidth);
        this.valueBuffer = buffers.getDataBuf();
        this.validityBuffer = buffers.getValidityBuf();
        this.zeroVector();
        this.lastValueCapacity = this.getValueCapacity();
    }

    private void allocateValidityBuffer(int validityBufferSize) {
        this.validityBuffer = this.allocator.buffer(validityBufferSize);
        this.validityBuffer.readerIndex(0L);
    }

    @Override
    public int getBufferSizeFor(int count) {
        if (count == 0) {
            return 0;
        }
        return count * this.typeWidth + BaseFixedWidthVector.getValidityBufferSizeFromCount(count);
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * this.typeWidth + BaseFixedWidthVector.getValidityBufferSizeFromCount(this.valueCount);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        this.setReaderAndWriterIndex();
        ArrowBuf[] buffers = this.getBufferSize() == 0 ? new ArrowBuf[]{} : new ArrowBuf[]{this.validityBuffer, this.valueBuffer};
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void reAlloc() {
        int targetValueCount = this.getValueCapacity() * 2;
        if (targetValueCount == 0) {
            targetValueCount = this.lastValueCapacity > 0 ? this.lastValueCapacity : 7940;
        }
        this.computeAndCheckBufferSize(targetValueCount);
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(targetValueCount, this.typeWidth);
        ArrowBuf newValueBuffer = buffers.getDataBuf();
        newValueBuffer.setBytes(0L, this.valueBuffer, 0L, this.valueBuffer.capacity());
        newValueBuffer.setZero(this.valueBuffer.capacity(), newValueBuffer.capacity() - this.valueBuffer.capacity());
        this.valueBuffer.getReferenceManager().release();
        this.valueBuffer = newValueBuffer;
        ArrowBuf newValidityBuffer = buffers.getValidityBuf();
        newValidityBuffer.setBytes(0L, this.validityBuffer, 0L, this.validityBuffer.capacity());
        newValidityBuffer.setZero(this.validityBuffer.capacity(), newValidityBuffer.capacity() - this.validityBuffer.capacity());
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = newValidityBuffer;
        this.lastValueCapacity = this.getValueCapacity();
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("primitive type vector can not have children");
        }
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.emptyList();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 2) {
            throw new IllegalArgumentException("Illegal buffer count, expected 2, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        ArrowBuf dataBuffer = ownBuffers.get(1);
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.valueBuffer.getReferenceManager().release();
        this.valueBuffer = dataBuffer.getReferenceManager().retain(dataBuffer, this.allocator);
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(2);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.valueBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0L);
        this.valueBuffer.readerIndex(0L);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0L);
            this.valueBuffer.writerIndex(0L);
        } else {
            this.validityBuffer.writerIndex(BaseFixedWidthVector.getValidityBufferSizeFromCount(this.valueCount));
            if (this.typeWidth == 0) {
                this.valueBuffer.writerIndex(BaseFixedWidthVector.getValidityBufferSizeFromCount(this.valueCount));
            } else {
                this.valueBuffer.writerIndex((long)this.valueCount * (long)this.typeWidth);
            }
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.getName(), allocator);
    }

    @Override
    public abstract TransferPair getTransferPair(String var1, BufferAllocator var2);

    public void transferTo(BaseFixedWidthVector target) {
        this.compareTypes(target, "transferTo");
        target.clear();
        target.validityBuffer = BaseFixedWidthVector.transferBuffer(this.validityBuffer, target.allocator);
        target.valueBuffer = BaseFixedWidthVector.transferBuffer(this.valueBuffer, target.allocator);
        target.valueCount = this.valueCount;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BaseFixedWidthVector target) {
        Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)this.valueCount);
        this.compareTypes(target, "splitAndTransferTo");
        target.clear();
        this.splitAndTransferValidityBuffer(startIndex, length, target);
        this.splitAndTransferValueBuffer(startIndex, length, target);
        target.setValueCount(length);
    }

    private void splitAndTransferValueBuffer(int startIndex, int length, BaseFixedWidthVector target) {
        int startPoint = startIndex * this.typeWidth;
        int sliceLength = length * this.typeWidth;
        ArrowBuf slicedBuffer = this.valueBuffer.slice(startPoint, sliceLength);
        target.valueBuffer = BaseFixedWidthVector.transferBuffer(slicedBuffer, target.allocator);
    }

    private void splitAndTransferValidityBuffer(int startIndex, int length, BaseFixedWidthVector target) {
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BaseFixedWidthVector.getValidityBufferSizeFromCount(length);
        int offset = startIndex % 8;
        if (length > 0) {
            if (offset == 0) {
                if (target.validityBuffer != null) {
                    target.validityBuffer.getReferenceManager().release();
                }
                target.validityBuffer = this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                target.validityBuffer.getReferenceManager().retain(1);
            } else {
                byte b1;
                target.allocateValidityBuffer(byteSizeTarget);
                for (int i = 0; i < byteSizeTarget - 1; ++i) {
                    byte b12 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + i, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + i + 1, offset);
                    target.validityBuffer.setByte((long)i, b12 + b2);
                }
                if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                    target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
                } else {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1);
                }
            }
        }
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        int currentValueCapacity = this.getValueCapacity();
        while (valueCount > this.getValueCapacity()) {
            this.reAlloc();
        }
        if (valueCount > 0) {
            if (currentValueCapacity >= valueCount * 2) {
                this.incrementAllocationMonitor();
            } else if (currentValueCapacity <= valueCount / 2) {
                this.decrementAllocationMonitor();
            }
        }
        this.setReaderAndWriterIndex();
    }

    public boolean isSafe(int index) {
        return index < this.getValueCapacity();
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public void setIndexDefined(int index) {
        this.handleSafe(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
    }

    public void set(int index, byte[] value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    public void setSafe(int index, byte[] value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    public void set(int index, ByteBuffer value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    public void setSafe(int index, ByteBuffer value, int start, int length) {
        throw new UnsupportedOperationException();
    }

    protected void handleSafe(int index) {
        while (index >= this.getValueCapacity()) {
            this.decrementAllocationMonitor();
            this.reAlloc();
        }
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        if (from.isNull(fromIndex)) {
            BitVectorHelper.unsetBit(this.getValidityBuffer(), thisIndex);
        } else {
            BitVectorHelper.setBit(this.getValidityBuffer(), thisIndex);
            PlatformDependent.copyMemory(from.getDataBuffer().memoryAddress() + (long)fromIndex * (long)this.typeWidth, this.getDataBuffer().memoryAddress() + (long)thisIndex * (long)this.typeWidth, this.typeWidth);
        }
    }

    @Override
    public void copyFromSafe(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.unsetBit(this.validityBuffer, index);
    }

    @Override
    public ArrowBufPointer getDataPointer(int index) {
        return this.getDataPointer(index, new ArrowBufPointer());
    }

    @Override
    public ArrowBufPointer getDataPointer(int index, ArrowBufPointer reuse) {
        if (this.isNull(index)) {
            reuse.set(null, 0L, 0L);
        } else {
            reuse.set(this.valueBuffer, (long)index * (long)this.typeWidth, this.typeWidth);
        }
        return reuse;
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        if (this.isNull(index)) {
            return 0;
        }
        long start = (long)this.typeWidth * (long)index;
        long end = (long)this.typeWidth * (long)(index + 1);
        return ByteFunctionHelpers.hash(hasher, this.getDataBuffer(), start, end);
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }
}

