/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory.rounding;

import cdjd.org.apache.arrow.memory.NettyAllocationManager;
import cdjd.org.apache.arrow.memory.rounding.RoundingPolicy;
import cdjd.org.apache.arrow.memory.util.CommonUtil;
import java.lang.reflect.Field;

public class DefaultRoundingPolicy
implements RoundingPolicy {
    public final long chunkSize;
    public static final DefaultRoundingPolicy INSTANCE = new DefaultRoundingPolicy();

    private DefaultRoundingPolicy() {
        try {
            Field field = NettyAllocationManager.class.getDeclaredField("CHUNK_SIZE");
            field.setAccessible(true);
            this.chunkSize = (Long)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get chunk size from allocation manager");
        }
    }

    @Override
    public long getRoundedSize(long requestSize) {
        return requestSize < this.chunkSize ? CommonUtil.nextPowerOfTwo(requestSize) : requestSize;
    }
}

