/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.org.apache.arrow.memory.AllocationManager;
import cdjd.org.apache.arrow.memory.BaseAllocator;
import cdjd.org.apache.arrow.memory.util.MemoryUtil;

public final class UnsafeAllocationManager
extends AllocationManager {
    public static final AllocationManager.Factory FACTORY = UnsafeAllocationManager::new;
    private final long allocatedSize;
    private final long allocatedAddress;

    UnsafeAllocationManager(BaseAllocator accountingAllocator, long requestedSize) {
        super(accountingAllocator);
        this.allocatedAddress = MemoryUtil.UNSAFE.allocateMemory(requestedSize);
        this.allocatedSize = requestedSize;
    }

    @Override
    public long getSize() {
        return this.allocatedSize;
    }

    @Override
    protected long memoryAddress() {
        return this.allocatedAddress;
    }

    @Override
    protected void release0() {
        MemoryUtil.UNSAFE.freeMemory(this.allocatedAddress);
    }
}

