/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.io.netty.buffer.PooledByteBufAllocatorL;
import cdjd.io.netty.buffer.UnsafeDirectLittleEndian;
import cdjd.io.netty.util.internal.PlatformDependent;
import cdjd.org.apache.arrow.memory.AllocationManager;
import cdjd.org.apache.arrow.memory.BaseAllocator;

public class NettyAllocationManager
extends AllocationManager {
    public static final AllocationManager.Factory FACTORY = NettyAllocationManager::new;
    public static final int DEFAULT_ALLOCATION_CUTOFF_VALUE = Integer.MAX_VALUE;
    private static final PooledByteBufAllocatorL INNER_ALLOCATOR = new PooledByteBufAllocatorL();
    static final UnsafeDirectLittleEndian EMPTY = NettyAllocationManager.INNER_ALLOCATOR.empty;
    static final long CHUNK_SIZE = INNER_ALLOCATOR.getChunkSize();
    private final long allocatedSize;
    private final UnsafeDirectLittleEndian memoryChunk;
    private final long allocatedAddress;
    private final int allocationCutOffValue;

    NettyAllocationManager(BaseAllocator accountingAllocator, long requestedSize, int allocationCutOffValue) {
        super(accountingAllocator);
        this.allocationCutOffValue = allocationCutOffValue;
        if (requestedSize > (long)allocationCutOffValue) {
            this.memoryChunk = null;
            this.allocatedAddress = PlatformDependent.allocateMemory(requestedSize);
            this.allocatedSize = requestedSize;
        } else {
            this.memoryChunk = INNER_ALLOCATOR.allocate(requestedSize);
            this.allocatedAddress = this.memoryChunk.memoryAddress();
            this.allocatedSize = this.memoryChunk.capacity();
        }
    }

    NettyAllocationManager(BaseAllocator accountingAllocator, long requestedSize) {
        this(accountingAllocator, requestedSize, Integer.MAX_VALUE);
    }

    @Deprecated
    UnsafeDirectLittleEndian getMemoryChunk() {
        return this.memoryChunk;
    }

    @Override
    protected long memoryAddress() {
        return this.allocatedAddress;
    }

    @Override
    protected void release0() {
        if (this.memoryChunk == null) {
            PlatformDependent.freeMemory(this.allocatedAddress);
        } else {
            this.memoryChunk.release();
        }
    }

    @Override
    public long getSize() {
        return this.allocatedSize;
    }
}

