/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.org.apache.arrow.memory.AllocationManager;
import cdjd.org.apache.arrow.memory.CheckAllocator;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAllocationManagerOption {
    public static final String ALLOCATION_MANAGER_TYPE_ENV_NAME = "ARROW_ALLOCATION_MANAGER_TYPE";
    public static final String ALLOCATION_MANAGER_TYPE_PROPERTY_NAME = "arrow.allocation.manager.type";
    static final Logger LOGGER = LoggerFactory.getLogger(DefaultAllocationManagerOption.class);
    public static final AllocationManager.Factory DEFAULT_ALLOCATION_MANAGER_FACTORY = DefaultAllocationManagerOption.getDefaultAllocationManagerFactory();

    static AllocationManagerType getDefaultAllocationManagerType() {
        AllocationManagerType ret = AllocationManagerType.Unknown;
        try {
            String envValue = System.getenv(ALLOCATION_MANAGER_TYPE_ENV_NAME);
            ret = AllocationManagerType.valueOf(envValue);
        }
        catch (IllegalArgumentException | NullPointerException envValue) {
            // empty catch block
        }
        try {
            String propValue = System.getProperty(ALLOCATION_MANAGER_TYPE_PROPERTY_NAME);
            ret = AllocationManagerType.valueOf(propValue);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return ret;
    }

    static AllocationManager.Factory getDefaultAllocationManagerFactory() {
        AllocationManagerType type = DefaultAllocationManagerOption.getDefaultAllocationManagerType();
        switch (type) {
            case Netty: {
                return DefaultAllocationManagerOption.getNettyFactory();
            }
            case Unsafe: {
                return DefaultAllocationManagerOption.getUnsafeFactory();
            }
            case Unknown: {
                LOGGER.info("allocation manager type not specified, using netty as the default type");
                return DefaultAllocationManagerOption.getFactory(CheckAllocator.check());
            }
        }
        throw new IllegalStateException("Unknown allocation manager type: " + (Object)((Object)type));
    }

    private static AllocationManager.Factory getFactory(String clazzName) {
        try {
            Field field = Class.forName(clazzName).getDeclaredField("FACTORY");
            field.setAccessible(true);
            return (AllocationManager.Factory)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate Allocation Manager for " + clazzName, e);
        }
    }

    private static AllocationManager.Factory getUnsafeFactory() {
        return DefaultAllocationManagerOption.getFactory("cdjd.org.apache.arrow.memory.UnsafeAllocationManager");
    }

    private static AllocationManager.Factory getNettyFactory() {
        return DefaultAllocationManagerOption.getFactory("cdjd.org.apache.arrow.memory.NettyAllocationManager");
    }

    public static enum AllocationManagerType {
        Netty,
        Unsafe,
        Unknown;

    }
}

