/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CheckAllocator {
    private static final Logger logger = LoggerFactory.getLogger(CheckAllocator.class);
    private static final String ALLOCATOR_PATH = "cdjd/org/apache/arrow/memory/DefaultAllocationManagerFactory.class";

    private CheckAllocator() {
    }

    static String check() {
        Set<URL> urls = CheckAllocator.scanClasspath();
        URL rootAllocator = CheckAllocator.assertOnlyOne(urls);
        CheckAllocator.reportResult(rootAllocator);
        return "cdjd.org.apache.arrow.memory.DefaultAllocationManagerFactory";
    }

    private static Set<URL> scanClasspath() {
        LinkedHashSet<URL> allocatorPathSet = new LinkedHashSet<URL>();
        try {
            ClassLoader allocatorClassLoader = CheckAllocator.class.getClassLoader();
            Enumeration<URL> paths = allocatorClassLoader == null ? ClassLoader.getSystemResources(ALLOCATOR_PATH) : allocatorClassLoader.getResources(ALLOCATOR_PATH);
            while (paths.hasMoreElements()) {
                URL path = paths.nextElement();
                allocatorPathSet.add(path);
            }
        }
        catch (IOException ioe) {
            logger.error("Error getting resources from path", ioe);
        }
        return allocatorPathSet;
    }

    private static void reportResult(URL rootAllocator) {
        String path = rootAllocator.getPath();
        String subPath = path.substring(path.indexOf("memory"));
        logger.info("Using DefaultAllocationManager at {}", (Object)subPath);
    }

    private static URL assertOnlyOne(Set<URL> urls) {
        if (urls.size() > 1) {
            logger.warn("More than one DefaultAllocationManager on classpath. Choosing first found");
        }
        if (urls.isEmpty()) {
            throw new RuntimeException("No DefaultAllocationManager found on classpath. Can't allocate Arrow buffers.");
        }
        return urls.iterator().next();
    }
}

