/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.org.apache.arrow.memory.Accountant;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import java.util.ArrayDeque;
import java.util.Deque;

public class AllocationOutcomeDetails {
    Deque<Entry> allocEntries = new ArrayDeque<Entry>();

    AllocationOutcomeDetails() {
    }

    void pushEntry(Accountant accountant, long totalUsedBeforeAllocation, long requestedSize, long allocatedSize, boolean allocationFailed) {
        Entry top = this.allocEntries.peekLast();
        if (top != null && top.allocationFailed) {
            return;
        }
        this.allocEntries.addLast(new Entry(accountant, totalUsedBeforeAllocation, requestedSize, allocatedSize, allocationFailed));
    }

    public BufferAllocator getFailedAllocator() {
        Entry top = this.allocEntries.peekLast();
        if (top != null && top.allocationFailed && top.accountant instanceof BufferAllocator) {
            return (BufferAllocator)((Object)top.accountant);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Allocation outcome details:\n");
        this.allocEntries.forEach(sb::append);
        return sb.toString();
    }

    public static class Entry {
        private final Accountant accountant;
        private final long limit;
        private final long used;
        private final long requestedSize;
        private final long allocatedSize;
        private final boolean allocationFailed;

        Entry(Accountant accountant, long totalUsedBeforeAllocation, long requestedSize, long allocatedSize, boolean allocationFailed) {
            this.accountant = accountant;
            this.limit = accountant.getLimit();
            this.used = totalUsedBeforeAllocation;
            this.requestedSize = requestedSize;
            this.allocatedSize = allocatedSize;
            this.allocationFailed = allocationFailed;
        }

        public Accountant getAccountant() {
            return this.accountant;
        }

        public long getLimit() {
            return this.limit;
        }

        public long getUsed() {
            return this.used;
        }

        public long getRequestedSize() {
            return this.requestedSize;
        }

        public long getAllocatedSize() {
            return this.allocatedSize;
        }

        public boolean isAllocationFailed() {
            return this.allocationFailed;
        }

        public String toString() {
            return "allocator[" + this.accountant.getName() + "]" + (" reservation: " + this.accountant.getInitReservation()) + (" limit: " + this.limit) + (" used: " + this.used) + (" requestedSize: " + this.requestedSize) + (" allocatedSize: " + this.allocatedSize) + (" localAllocationStatus: " + (this.allocationFailed ? "fail" : "success")) + "\n";
        }
    }
}

