/*
 * Decompiled with CFR 0.152.
 */
package cdjd.javassist.expr;

import cdjd.javassist.CannotCompileException;
import cdjd.javassist.ClassPool;
import cdjd.javassist.CtBehavior;
import cdjd.javassist.CtClass;
import cdjd.javassist.NotFoundException;
import cdjd.javassist.bytecode.BadBytecode;
import cdjd.javassist.bytecode.Bytecode;
import cdjd.javassist.bytecode.CodeAttribute;
import cdjd.javassist.bytecode.CodeIterator;
import cdjd.javassist.bytecode.ConstPool;
import cdjd.javassist.bytecode.MethodInfo;
import cdjd.javassist.compiler.CompileError;
import cdjd.javassist.compiler.Javac;
import cdjd.javassist.compiler.JvstCodeGen;
import cdjd.javassist.compiler.JvstTypeChecker;
import cdjd.javassist.compiler.ProceedHandler;
import cdjd.javassist.compiler.ast.ASTList;
import cdjd.javassist.expr.Expr;

public class Cast
extends Expr {
    protected Cast(int pos, CodeIterator i, CtClass declaring, MethodInfo m3) {
        super(pos, i, declaring, m3);
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    public CtClass getType() throws NotFoundException {
        ConstPool cp = this.getConstPool();
        int pos = this.currentPos;
        int index = this.iterator.u16bitAt(pos + 1);
        String name = cp.getClassInfo(index);
        return this.thisClass.getClassPool().getCtClass(name);
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    @Override
    public void replace(String statement) throws CannotCompileException {
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int pos = this.currentPos;
        int index = this.iterator.u16bitAt(pos + 1);
        Javac jc = new Javac(this.thisClass);
        ClassPool cp = this.thisClass.getClassPool();
        CodeAttribute ca = this.iterator.get();
        try {
            CtClass[] params = new CtClass[]{cp.get("java.lang.Object")};
            CtClass retType = this.getType();
            int paramVar = ca.getMaxLocals();
            jc.recordParams("java.lang.Object", params, true, paramVar, this.withinStatic());
            int retVar = jc.recordReturnType(retType, true);
            jc.recordProceed(new ProceedForCast(index, retType));
            Cast.checkResultValue(retType, statement);
            Bytecode bytecode = jc.getBytecode();
            Cast.storeStack(params, true, paramVar, bytecode);
            jc.recordLocalVariables(ca, pos);
            bytecode.addConstZero(retType);
            bytecode.addStore(retVar, retType);
            jc.compileStmnt(statement);
            bytecode.addLoad(retVar, retType);
            this.replace0(pos, bytecode, 3);
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException("broken method");
        }
    }

    static class ProceedForCast
    implements ProceedHandler {
        int index;
        CtClass retType;

        ProceedForCast(int i, CtClass t) {
            this.index = i;
            this.retType = t;
        }

        @Override
        public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args) throws CompileError {
            if (gen.getMethodArgsLength(args) != 1) {
                throw new CompileError("$proceed() cannot take more than one parameter for cast");
            }
            gen.atMethodArgs(args, new int[1], new int[1], new String[1]);
            bytecode.addOpcode(192);
            bytecode.addIndex(this.index);
            gen.setType(this.retType);
        }

        @Override
        public void setReturnType(JvstTypeChecker c, ASTList args) throws CompileError {
            c.atMethodArgs(args, new int[1], new int[1], new String[1]);
            c.setType(this.retType);
        }
    }
}

