/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator.zk;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.service.coordinator.ClusterCoordinator;
import cdjd.com.dremio.service.coordinator.DistributedSemaphore;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterClient;
import cdjd.com.dremio.service.coordinator.zk.ZKServiceSet;
import cdjd.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKClusterCoordinator
extends ClusterCoordinator {
    static final Logger logger = LoggerFactory.getLogger(ZKClusterCoordinator.class);
    private final ZKClusterClient zkClient;
    private final ConcurrentMap<String, ZKServiceSet> serviceSets = new ConcurrentHashMap<String, ZKServiceSet>();
    private volatile boolean closed = false;

    public ZKClusterCoordinator(SabotConfig config) throws IOException {
        this(config, (String)null);
    }

    public ZKClusterCoordinator(SabotConfig config, String connect) throws IOException {
        this.zkClient = new ZKClusterClient(config, connect);
    }

    public ZKClusterCoordinator(SabotConfig config, Provider<Integer> localPort) throws IOException {
        this.zkClient = new ZKClusterClient(config, localPort);
    }

    @VisibleForTesting
    ZKClusterClient getZkClient() {
        return this.zkClient;
    }

    @VisibleForTesting
    public void setPortProvider(Provider<Integer> portProvider) {
        this.zkClient.setPortProvider(portProvider);
    }

    @Override
    public void start() throws Exception {
        this.zkClient.start();
        if (!this.closed) {
            Thread.sleep(5L);
            for (Service service : Service.values()) {
                ZKServiceSet serviceSet = this.zkClient.newServiceSet(service.name);
                serviceSet.start();
                this.serviceSets.put(service.role.name(), serviceSet);
            }
            logger.info("ZKClusterCoordination is up");
        }
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return (ServiceSet)this.serviceSets.get(role.name());
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String serviceName) {
        return this.serviceSets.computeIfAbsent(serviceName, s2 -> {
            ZKServiceSet newServiceSet = this.zkClient.newServiceSet(serviceName);
            try {
                newServiceSet.start();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to start %s service in Zookeeper", serviceName), e);
            }
            return newServiceSet;
        });
    }

    @Override
    public Iterable<String> getServiceNames() throws Exception {
        return this.zkClient.getServiceNames();
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        return this.zkClient.getSemaphore(name, maximumLeases);
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        return this.zkClient.joinElection(name, listener);
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            AutoCloseables.close(this.serviceSets.values(), AutoCloseables.iter(this.zkClient));
        }
    }

    private static enum Service {
        COORDINATOR(ClusterCoordinator.Role.COORDINATOR, "coordinator"),
        EXECUTOR(ClusterCoordinator.Role.EXECUTOR, "executor"),
        MASTER(ClusterCoordinator.Role.MASTER, "master");

        private final ClusterCoordinator.Role role;
        private final String name;

        private Service(ClusterCoordinator.Role role, String serviceName) {
            this.role = role;
            this.name = serviceName;
        }
    }
}

