/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.service.Service;
import cdjd.com.dremio.service.coordinator.DistributedSemaphore;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import java.util.EnumSet;
import java.util.Set;

public abstract class ClusterCoordinator
implements Service {
    public abstract ServiceSet getServiceSet(Role var1);

    public abstract ServiceSet getOrCreateServiceSet(String var1);

    public abstract Iterable<String> getServiceNames() throws Exception;

    public abstract DistributedSemaphore getSemaphore(String var1, int var2);

    public abstract ElectionRegistrationHandle joinElection(String var1, ElectionListener var2);

    public static enum Role {
        COORDINATOR{

            @Override
            protected void updateEndpointRoles(CoordinationProtos.Roles.Builder roles, boolean enable) {
                roles.setSqlQuery(enable);
            }

            @Override
            protected boolean contains(CoordinationProtos.Roles roles) {
                return roles.getSqlQuery();
            }
        }
        ,
        EXECUTOR{

            @Override
            protected void updateEndpointRoles(CoordinationProtos.Roles.Builder roles, boolean enable) {
                roles.setJavaExecutor(enable);
            }

            @Override
            protected boolean contains(CoordinationProtos.Roles roles) {
                return roles.getJavaExecutor();
            }
        }
        ,
        MASTER{

            @Override
            protected void updateEndpointRoles(CoordinationProtos.Roles.Builder roles, boolean enable) {
                roles.setMaster(enable);
            }

            @Override
            protected boolean contains(CoordinationProtos.Roles roles) {
                return roles.getMaster();
            }
        };


        protected abstract boolean contains(CoordinationProtos.Roles var1);

        protected abstract void updateEndpointRoles(CoordinationProtos.Roles.Builder var1, boolean var2);

        public static Set<Role> fromEndpointRoles(CoordinationProtos.Roles endpointRoles) {
            EnumSet<Role> roles = EnumSet.noneOf(Role.class);
            for (Role role : Role.values()) {
                if (!role.contains(endpointRoles)) continue;
                roles.add(role);
            }
            return roles;
        }

        public static CoordinationProtos.Roles toEndpointRoles(Set<Role> roles) {
            CoordinationProtos.Roles.Builder builder = CoordinationProtos.Roles.newBuilder();
            for (Role role : Role.values()) {
                role.updateEndpointRoles(builder, roles.contains((Object)role));
            }
            return builder.build();
        }
    }

    public static final class Options {
        public static final String CLUSTER_ID = "dremio.exec.cluster-id";
        public static final String ZK_CONNECTION = "dremio.exec.zk.connect";
        public static final String ZK_RETRY_BASE_DELAY = "dremio.exec.zk.retry.delay.base";
        public static final String ZK_RETRY_MAX_DELAY = "dremio.exec.zk.retry.delay.max";
        public static final String ZK_ROOT = "dremio.exec.zk.root";
        public static final String ZK_TIMEOUT = "dremio.exec.zk.timeout";
        public static final String ZK_SESSION_TIMEOUT = "dremio.exec.zk.session.timeout";
        public static final String ZK_ELECTION_TIMEOUT = "dremio.exec.zk.election.timeout";
        public static final String ZK_ELECTION_POLLING = "dremio.exec.zk.election.polling";
        public static final String ZK_RETRY_UNLIMITED = "dremio.exec.zk.retry.unlimited";
        public static final String ZK_RETRY_LIMIT = "dremio.exec.zk.retry.limit";
        public static final String ZK_INITIAL_TIMEOUT_MS = "dremio.exec.zk.retry.initial_timeout_ms";

        private Options() {
        }
    }
}

