/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.common.perf.Timer;
import cdjd.com.dremio.service.Service;
import cdjd.com.dremio.service.SingletonRegistry;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.base.Objects;
import cdjd.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(SingletonRegistry.class);
    private volatile boolean closed = false;
    private final List<Service> services = new ArrayList<Service>();
    private final boolean timerEnabled;

    public ServiceRegistry() {
        this(Timer.enabled());
    }

    @VisibleForTesting
    ServiceRegistry(boolean timerEnabled) {
        this.timerEnabled = timerEnabled;
    }

    public <T extends Service> T register(@Nullable T service) {
        if (service != null) {
            this.services.add(this.wrapService(service));
        }
        return service;
    }

    public <T extends Service> T replace(@Nullable T service) {
        if (service == null) {
            return null;
        }
        Service toReplace = this.wrapService(service);
        ListIterator<Service> it = this.services.listIterator();
        while (it.hasNext()) {
            Service s2 = it.next();
            if (!toReplace.equals(s2)) continue;
            it.remove();
            try {
                s2.close();
            }
            catch (Exception e) {
                logger.warn("Exception when closing service {}", (Object)s2, (Object)e);
            }
            it.add(toReplace);
            return service;
        }
        throw new IllegalArgumentException("Trying to replace an unregistered service");
    }

    private Service wrapService(Service service) {
        return this.timerEnabled ? new TimedService(service) : service;
    }

    @Override
    public void start() throws Exception {
        for (Service service : this.services) {
            service.start();
        }
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            AutoCloseables.close(Lists.reverse(this.services));
        }
    }

    protected List<Service> getServices() {
        return this.services;
    }

    private static final class TimedService
    implements Service {
        private final Service delegate;
        private final String name;

        private TimedService(Service delegate) {
            this.delegate = delegate;
            this.name = delegate.getClass().getSimpleName();
        }

        @Override
        public void close() throws Exception {
            try (Timer.TimedBlock b = Timer.time(this.name + ".close");){
                this.delegate.close();
            }
        }

        @Override
        public void start() throws Exception {
            try (Timer.TimedBlock b = Timer.time(this.name + ".start");){
                this.delegate.start();
            }
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TimedService)) {
                return false;
            }
            TimedService other = (TimedService)obj;
            return Objects.equal(this.delegate, other.delegate);
        }
    }
}

