/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service;

import cdjd.com.dremio.service.Binder;
import cdjd.com.dremio.service.BindingCreator;
import cdjd.com.dremio.service.BindingProvider;
import cdjd.com.dremio.service.Pointer;
import cdjd.com.google.common.base.Function;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.base.Predicate;
import cdjd.com.google.common.collect.Collections2;
import cdjd.com.google.common.collect.FluentIterable;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.com.google.common.collect.ImmutableMap;
import cdjd.com.google.common.collect.Iterators;
import cdjd.com.google.common.collect.Maps;
import cdjd.com.google.inject.ConfigurationException;
import cdjd.com.google.inject.Injector;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;

public class BinderImpl
implements Binder {
    private Injector injector;
    private final BinderImpl parent;
    private volatile Map<Class<?>, Resolver> lookups = ImmutableMap.of();

    public BinderImpl() {
        this.parent = null;
    }

    public BinderImpl(BinderImpl parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyBindings(BinderImpl target) {
        BinderImpl binderImpl = target;
        synchronized (binderImpl) {
            ImmutableMap.Builder<Class<?>, Resolver> newMap = ImmutableMap.builder();
            newMap.putAll(target.lookups);
            newMap.putAll(this.lookups);
            target.lookups = newMap.build();
        }
    }

    @Override
    public <T> Provider<T> provider(Class<T> iface) {
        return new DeferredProvider<T>(iface);
    }

    private Resolver getResolver(Class<?> iface) {
        Resolver r = this.lookups.get(iface);
        if (r != null) {
            return r;
        }
        if (this.parent != null) {
            return this.parent.getResolver(iface);
        }
        return null;
    }

    @Override
    public <T> T lookup(Class<T> iface) {
        Preconditions.checkNotNull(iface, "Must provided desired interface or class.");
        Resolver lookup = this.getResolver(iface);
        if (lookup == null && this.injector != null) {
            try {
                return (T)this.injector.getInstance(iface);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        Preconditions.checkNotNull(lookup, "Unable to find injectable based on %s", (Object)iface.getName());
        return (T)lookup.get(this);
    }

    @Override
    public <IFACE> void bindSelf(Class<IFACE> iface) {
        this.bind(iface, new InjectableReference(iface));
    }

    @Override
    public <IFACE> IFACE bindSelf(IFACE impl) {
        return (IFACE)this.bindInternal(impl.getClass(), impl);
    }

    @Override
    public <IFACE> void bind(Class<IFACE> iface, Class<? extends IFACE> impl) {
        this.bind(iface, new InjectableReference(impl));
    }

    @Override
    public synchronized <IFACE> void replace(Class<IFACE> iface, Class<? extends IFACE> impl) {
        this.remove(iface);
        this.bind(iface, (IFACE)impl);
    }

    @Override
    public <IFACE> IFACE bind(Class<IFACE> iface, IFACE impl) {
        this.bind(iface, new GenericReference(impl));
        return impl;
    }

    @Override
    public synchronized <IFACE> boolean bindIfUnbound(Class<IFACE> iface, IFACE impl) {
        if (!this.lookups.containsKey(iface)) {
            this.bind(iface, impl);
            return true;
        }
        return false;
    }

    private <IFACE> IFACE bindInternal(Class<IFACE> iface, @Nullable IFACE impl) {
        this.bind(iface, this.wrap(impl));
        return impl;
    }

    protected synchronized <IFACE> void bind(Class<IFACE> iface, Resolver reference) {
        Preconditions.checkNotNull(iface);
        ImmutableMap.Builder<Class<?>, Resolver> newLookups = ImmutableMap.builder();
        newLookups.putAll(this.lookups);
        newLookups.put(iface, reference);
        this.lookups = newLookups.build();
    }

    @Override
    public synchronized <IFACE> void bindProvider(Class<IFACE> iface, Provider<? extends IFACE> provider) {
        Preconditions.checkNotNull(iface);
        ImmutableMap.Builder<Class<?>, Resolver> newLookups = ImmutableMap.builder();
        newLookups.putAll(this.lookups);
        newLookups.put(iface, this.wrap(provider));
        this.lookups = newLookups.build();
    }

    @Override
    public synchronized <IFACE> void replaceProvider(Class<IFACE> iface, Provider<? extends IFACE> provider) {
        Preconditions.checkNotNull(iface);
        if (this.lookups.containsKey(iface)) {
            this.remove(iface);
        }
        this.bindProvider(iface, provider);
    }

    private synchronized void remove(final Class<?> iface) {
        ImmutableMap.Builder<Class<?>, Resolver> newLookups = ImmutableMap.builder();
        final Pointer removed = new Pointer();
        newLookups.putAll(Maps.filterEntries(this.lookups, new Predicate<Map.Entry<Class<?>, Resolver>>(){

            @Override
            public boolean apply(Map.Entry<Class<?>, Resolver> input) {
                boolean matches = input.getKey().equals(iface);
                if (matches) {
                    removed.value = input.getValue();
                }
                return !matches;
            }
        }));
        if (removed.value == null) {
            throw new IllegalStateException("Trying to remove an unbound value. No singleton is bound to " + iface.getName());
        }
        this.lookups = newLookups.build();
    }

    @Override
    public synchronized <IFACE> void replace(Class<IFACE> iface, IFACE impl) {
        this.remove(iface);
        this.bindInternal(iface, impl);
    }

    protected synchronized <IFACE> void replace(Class<IFACE> iface, Resolver reference) {
        this.remove(iface);
        this.bind(iface, reference);
    }

    @Override
    public Iterator<Binding<?>> iterator() {
        return Iterators.transform(this.lookups.entrySet().iterator(), new Function<Map.Entry<Class<?>, Resolver>, Binding<?>>(){

            @Override
            public Binding apply(Map.Entry<Class<?>, Resolver> input) {
                switch (input.getValue().getType()) {
                    case INSTANCE: {
                        return new InstanceBinding(input.getKey(), ((InjectableReference)input.getValue()).clazz);
                    }
                    case SINGLETON: {
                        return new SingletonBinding(input.getKey(), input.getValue().get(null));
                    }
                    case PROVIDER: {
                        return new ProviderBinding(input.getKey(), ((ProviderReference)input.getValue()).getProvider());
                    }
                }
                throw new IllegalStateException();
            }
        });
    }

    public BindingCreator getBindingCreator() {
        return new BindingCreatorImpl();
    }

    public BindingProvider getBindingProvider() {
        return new BindingProviderImpl();
    }

    private Resolver wrap(Object obj) {
        if (obj instanceof Resolver) {
            return (Resolver)obj;
        }
        if (obj instanceof Provider) {
            return new ProviderReference((Provider)obj);
        }
        if (obj instanceof Class) {
            return new InjectableReference((Class)obj);
        }
        return new GenericReference(obj);
    }

    @Override
    public Binder newChild() {
        return new BinderImpl(this);
    }

    @Override
    public void registerGuiceInjector(Injector injector) {
        this.injector = injector;
    }

    public static class ProviderReference
    implements Resolver {
        private final Provider<?> provider;

        public ProviderReference(Provider<?> provider) {
            this.provider = provider;
        }

        @Override
        public Object get(BindingProvider bindingProvider) {
            return this.provider.get();
        }

        public Provider<?> getProvider() {
            return this.provider;
        }

        @Override
        public ResolverType getType() {
            return ResolverType.PROVIDER;
        }
    }

    public static class InjectableReference
    implements Resolver {
        private final Class<?> clazz;
        private final Constructor<?> constructor;
        private final List<FinalResolver> providers;

        public InjectableReference(Class<?> clazz) {
            this.clazz = clazz;
            Collection<Constructor<?>> annotated = Collections2.filter(Arrays.asList(clazz.getConstructors()), new Predicate<Constructor<?>>(){

                @Override
                public boolean apply(Constructor<?> input) {
                    return input.getAnnotation(Inject.class) != null;
                }
            });
            Preconditions.checkArgument(annotated.size() == 1, "Unable to treat class %s as injectable. It should have one and only one constructor marked with @Inject annotation. It has %s constructors with this annotation.", (Object)clazz.getName(), annotated.size());
            this.constructor = annotated.iterator().next();
            this.providers = Arrays.stream(this.constructor.getParameterTypes()).map(FinalResolver::new).collect(ImmutableList.toImmutableList());
        }

        @Override
        public Object get(final BindingProvider provider) {
            try {
                return this.constructor.newInstance(FluentIterable.from(this.providers).transform(new Function<FinalResolver, Object>(){

                    @Override
                    public Object apply(FinalResolver input) {
                        return input.getImplementation(provider);
                    }
                }).toArray(Object.class));
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failure while attempting to create %s.", this.clazz.getName()), ex);
            }
        }

        @Override
        public ResolverType getType() {
            return ResolverType.INSTANCE;
        }
    }

    private static class FinalResolver {
        private final Class<?> iface;

        public FinalResolver(Class<?> iface) {
            this.iface = iface;
        }

        public Object getImplementation(BindingProvider provider) {
            return provider.lookup(this.iface);
        }
    }

    public static class GenericReference
    implements Resolver {
        private Object inner;

        public GenericReference(Object inner) {
            this.inner = inner;
        }

        @Override
        public Object get(BindingProvider provider) {
            return this.inner;
        }

        @Override
        public ResolverType getType() {
            return ResolverType.SINGLETON;
        }
    }

    public static interface Resolver {
        public Object get(BindingProvider var1);

        public ResolverType getType();
    }

    private class BindingProviderImpl
    implements BindingProvider {
        private BindingProviderImpl() {
        }

        @Override
        public <T> Provider<T> provider(Class<T> iface) {
            return BinderImpl.this.provider(iface);
        }

        @Override
        public <T> T lookup(Class<T> iface) {
            return BinderImpl.this.lookup(iface);
        }

        @Override
        public Iterator<Binding<?>> iterator() {
            return BinderImpl.this.iterator();
        }

        @Override
        public Binder newChild() {
            return BinderImpl.this.newChild();
        }
    }

    private class BindingCreatorImpl
    implements BindingCreator {
        private BindingCreatorImpl() {
        }

        @Override
        public <IFACE> IFACE bindSelf(IFACE impl) {
            return BinderImpl.this.bindSelf(impl);
        }

        @Override
        public <IFACE> IFACE bind(Class<IFACE> iface, IFACE impl) {
            return (IFACE)BinderImpl.this.bindInternal(iface, impl);
        }

        @Override
        public <IFACE> boolean bindIfUnbound(Class<IFACE> iface, IFACE impl) {
            return BinderImpl.this.bindIfUnbound(iface, impl);
        }

        @Override
        public <IFACE> void replace(Class<IFACE> iface, IFACE impl) {
            BinderImpl.this.replace(iface, impl);
        }

        @Override
        public <IFACE> void bindSelf(Class<IFACE> iface) {
            BinderImpl.this.bindSelf(iface);
        }

        @Override
        public <IFACE> void bind(Class<IFACE> iface, Class<? extends IFACE> impl) {
            BinderImpl.this.bind(iface, impl);
        }

        @Override
        public <IFACE> void replace(Class<IFACE> iface, Class<? extends IFACE> impl) {
            BinderImpl.this.replace(iface, impl);
        }

        @Override
        public <IFACE> void bindProvider(Class<IFACE> iface, Provider<? extends IFACE> provider) {
            BinderImpl.this.bindProvider(iface, provider);
        }

        @Override
        public <IFACE> void replaceProvider(Class<IFACE> iface, Provider<? extends IFACE> provider) {
            BinderImpl.this.replaceProvider(iface, provider);
        }
    }

    public static class ProviderBinding<T>
    extends Binding<T> {
        private final Provider<T> value;

        private ProviderBinding(Class<T> iface, Provider<T> value) {
            super(iface);
            this.value = value;
        }

        public Provider<T> getProvider() {
            return this.value;
        }

        @Override
        public ResolverType getType() {
            return ResolverType.PROVIDER;
        }
    }

    public static class SingletonBinding<T>
    extends Binding<T> {
        private final T singleton;

        private SingletonBinding(Class<T> iface, T singleton) {
            super(iface);
            this.singleton = singleton;
        }

        public Object getSingleton() {
            return this.singleton;
        }

        @Override
        public ResolverType getType() {
            return ResolverType.SINGLETON;
        }
    }

    public static class InstanceBinding<T>
    extends Binding<T> {
        private final Class<? extends T> instanceClass;

        private InstanceBinding(Class<T> iface, Class<? extends T> instanceClass) {
            super(iface);
            this.instanceClass = instanceClass;
        }

        public Class<? extends T> getInstance() {
            return this.instanceClass;
        }

        @Override
        public ResolverType getType() {
            return ResolverType.INSTANCE;
        }
    }

    public static abstract class Binding<T> {
        private final Class<T> iface;

        private Binding(Class<T> iface) {
            this.iface = iface;
        }

        public Class<?> getIface() {
            return this.iface;
        }

        public abstract ResolverType getType();
    }

    private class DeferredProvider<T>
    implements Provider<T> {
        private final Class<T> iface;

        public DeferredProvider(Class<T> iface) {
            this.iface = iface;
        }

        public T get() {
            return BinderImpl.this.lookup(this.iface);
        }
    }

    public static enum ResolverType {
        SINGLETON,
        INSTANCE,
        PROVIDER;

    }
}

