/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.sabot.rpc.user;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.sabot.rpc.user.BaseBackwardsCompatibilityHandler;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.buffer.NettyArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Dremio09BackwardCompatibilityHandler
extends BaseBackwardsCompatibilityHandler {
    private static final Logger logger = LoggerFactory.getLogger(Dremio09BackwardCompatibilityHandler.class);

    Dremio09BackwardCompatibilityHandler(BufferAllocator allocator) {
        super(allocator);
    }

    @Override
    public void patch(UserBitShared.SerializedField.Builder field, ByteBuf[] buffers, int bufferStart, int buffersLength, String parentName, String indent) {
        TypeProtos.DataMode mode = field.getMajorType().getMode();
        TypeProtos.MinorType minor = field.getMajorType().getMinorType();
        String name = field.getNamePart().getName();
        boolean changed = false;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("%sBEFORE PATCH: buffers %s for field %s.%s: %s %s expecting %s", indent, Dremio09BackwardCompatibilityHandler.sizesString(buffers, bufferStart, buffersLength), parentName, name, mode, minor, field.getBufferLength()));
        }
        List<UserBitShared.SerializedField.Builder> children = field.getChildBuilderList();
        if (field.getValueCount() != 0 && mode == TypeProtos.DataMode.OPTIONAL) {
            while (buffers[bufferStart].readableBytes() == 0) {
                ++bufferStart;
                --buffersLength;
            }
            if (minor == TypeProtos.MinorType.DECIMAL) {
                boolean decimalBufferIndex = true;
                UserBitShared.SerializedField.Builder decimalField = children.get(1);
                NettyArrowBuf decimalBuffer = (NettyArrowBuf)buffers[bufferStart + 1];
                if (decimalField.getMajorType().getMinorType() != TypeProtos.MinorType.DECIMAL || decimalField.getMajorType().getMode() != TypeProtos.DataMode.REQUIRED) {
                    throw new IllegalStateException("Found incorrect decimal field: " + field.build());
                }
                Dremio09BackwardCompatibilityHandler.patchDecimal(decimalBuffer);
                changed = true;
            }
        }
        int bufferLength = 0;
        for (int i = 0; i < buffersLength; ++i) {
            ByteBuf buffer = buffers[i + bufferStart];
            bufferLength += buffer.readableBytes();
        }
        if (field.getBufferLength() != bufferLength) {
            throw new IllegalStateException("Length of data in buffer should not have changed");
        }
        if (logger.isDebugEnabled() && changed) {
            logger.debug(String.format("%sAFTER PATCH: buffers %s for field %s.%s: %s %s expecting %s", indent, Dremio09BackwardCompatibilityHandler.sizesString(buffers, bufferStart, buffersLength), parentName, name, mode, minor, field.getBufferLength()));
        }
    }

    static void patchDecimal(NettyArrowBuf dataBuffer) {
        int decimalLength = 16;
        int startPoint = dataBuffer.readerIndex();
        int valueCount = dataBuffer.readableBytes() / 16;
        for (int i = 0; i < valueCount; ++i) {
            int j = startPoint;
            for (int k = startPoint + 16 - 1; j < k; ++j, --k) {
                byte firstByte = dataBuffer.getByte(j);
                byte lastByte = dataBuffer.getByte(k);
                dataBuffer.setByte(j, lastByte);
                dataBuffer.setByte(k, firstByte);
            }
            startPoint += 16;
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }
}

