/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.io.file;

import cdjd.com.google.common.base.Preconditions;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public final class MorePosixFilePermissions {
    private static final PosixFilePermission[] PERMISSIONS = PosixFilePermission.values();
    private static final int PERMISSIONS_LENGTH = PERMISSIONS.length;
    private static final int MAX_MODE = (1 << PERMISSIONS_LENGTH) - 1;

    private MorePosixFilePermissions() {
    }

    public static Set<PosixFilePermission> fromOctalMode(int mode) {
        Preconditions.checkArgument(0 <= mode && mode <= MAX_MODE, "mode should be between 0 and 0777");
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        int mask = 1 << PERMISSIONS_LENGTH - 1;
        for (PosixFilePermission permission : PERMISSIONS) {
            if ((mode & mask) != 0) {
                result.add(permission);
            }
            mask >>= 1;
        }
        return result;
    }

    public static Set<PosixFilePermission> fromOctalMode(String mode) {
        int m3 = Integer.parseInt(mode, 8);
        return MorePosixFilePermissions.fromOctalMode(m3);
    }
}

