/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.io.file;

import cdjd.com.dremio.io.CompressionCodec;
import cdjd.com.dremio.io.CompressionCodecFactory;
import cdjd.com.dremio.io.FSInputStream;
import cdjd.com.dremio.io.FSOutputStream;
import cdjd.com.dremio.io.file.FileAttributes;
import cdjd.com.dremio.io.file.FileSystem;
import cdjd.com.dremio.io.file.Path;
import cdjd.com.dremio.io.file.RecursiveDirectoryStream;
import cdjd.com.google.common.io.ByteStreams;
import cdjd.com.google.common.io.Closeables;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemUtils.class);
    private static final Queue<DeleteEntry> TO_DELETE_ON_EXIT = new ConcurrentLinkedQueue<DeleteEntry>();

    private FileSystemUtils() {
    }

    public static Object deleteOnExit(FileSystem fs, Path path) {
        DeleteEntry key = new DeleteEntry(fs, path);
        TO_DELETE_ON_EXIT.add(key);
        return key;
    }

    public static void cancelDeleteOnExit(Object key) {
        TO_DELETE_ON_EXIT.remove(key);
    }

    public static OutputStream create(FileSystem fs, Path file, Set<PosixFilePermission> permissions) throws IOException {
        FSOutputStream out = fs.create(file);
        try {
            fs.setPermission(file, permissions);
        }
        catch (IOException e) {
            Closeables.close(out, true);
            throw e;
        }
        return out;
    }

    public static FSInputStream openPossiblyCompressedStream(CompressionCodecFactory factory, FileSystem fs, Path path) throws IOException {
        CompressionCodec codec = factory.getCodec(path);
        if (codec != null) {
            return codec.newInputStream(fs.open(path));
        }
        return fs.open(path);
    }

    public static DirectoryStream<FileAttributes> listRecursive(FileSystem fs, Path path, Predicate<Path> pathFilter) throws IOException {
        DirectoryStream<FileAttributes> stream = fs.list(path, pathFilter);
        return new RecursiveDirectoryStream(fs, stream, pathFilter);
    }

    public static DirectoryStream<FileAttributes> globRecursive(FileSystem wrapper, Path pattern, Predicate<Path> filter) throws IOException {
        DirectoryStream<FileAttributes> globStream = wrapper.glob(pattern, filter);
        return new RecursiveDirectoryStream(wrapper, globStream, filter);
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource) throws IOException {
        return FileSystemUtils.copy(srcFS, src, dstFS, dst, deleteSource, true);
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite) throws IOException {
        FileAttributes fileAttributes = srcFS.getFileAttributes(src);
        return FileSystemUtils.copy(srcFS, fileAttributes, dstFS, dst, deleteSource, overwrite);
    }

    public static boolean copy(FileSystem srcFS, FileAttributes srcAttributes, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite) throws IOException {
        Path src = srcAttributes.getPath();
        dst = FileSystemUtils.checkDest(src.getName(), dstFS, dst, overwrite);
        if (srcAttributes.isDirectory()) {
            FileSystemUtils.checkDependencies(srcFS, src, dstFS, dst);
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            try (DirectoryStream<FileAttributes> contents = srcFS.list(src);){
                for (FileAttributes content : contents) {
                    FileSystemUtils.copy(srcFS, content, dstFS, dst.resolve(content.getPath().getName()), deleteSource, overwrite);
                }
            }
        }
        try (FSInputStream in = srcFS.open(src);
             FSOutputStream out = dstFS.create(dst, overwrite);){
            ByteStreams.copy(in, out);
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        if (dstFS.exists(dst)) {
            FileAttributes sdst = dstFS.getFileAttributes(dst);
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new IOException("Target " + dst + " is a directory");
                }
                return FileSystemUtils.checkDest(null, dstFS, dst.resolve(srcName), overwrite);
            }
            if (!overwrite) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }

    private static void checkDependencies(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        if (srcFS == dstFS) {
            String srcq = srcFS.makeQualified(src).toString() + "/";
            String dstq = dstFS.makeQualified(dst).toString() + "/";
            if (dstq.startsWith(srcq)) {
                if (srcq.length() == dstq.length()) {
                    throw new IOException("Cannot copy " + src + " to itself.");
                }
                throw new IOException("Cannot copy " + src + " to its subdirectory " + dst);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("files-delete-on-exit"){

            @Override
            public void run() {
                DeleteEntry entry = (DeleteEntry)TO_DELETE_ON_EXIT.poll();
                while (entry != null) {
                    try {
                        entry.fs.delete(entry.path, true);
                    }
                    catch (IOException | IllegalStateException e) {
                        LOGGER.warn("Could not delete path {}", (Object)entry.path, (Object)e);
                    }
                    entry = (DeleteEntry)TO_DELETE_ON_EXIT.poll();
                }
            }
        });
    }

    private static class DeleteEntry {
        private final FileSystem fs;
        private final Path path;

        public DeleteEntry(FileSystem fs, Path path) {
            this.fs = fs;
            this.path = path;
        }
    }
}

