/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.io;

import cdjd.com.dremio.common.exceptions.ErrorHelper;
import cdjd.com.dremio.io.AsyncByteReader;
import cdjd.com.google.common.util.concurrent.ThreadFactoryBuilder;
import cdjd.io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class AsyncByteReaderWithTimeout
implements AsyncByteReader {
    private static ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("timeoutAfter-%d").build());
    private AsyncByteReader inner;
    private long timeoutInMillis;

    public AsyncByteReaderWithTimeout(AsyncByteReader inner, long timeoutInMillis) {
        this.inner = inner;
        this.timeoutInMillis = timeoutInMillis;
    }

    @Override
    public CompletableFuture<Void> readFully(long offset, ByteBuf dst, int dstOffset, int len) {
        CompletionStage<Void> future = AsyncByteReaderWithTimeout.within(this.inner.readFully(offset, dst, dstOffset, len), this.timeoutInMillis);
        future = future.whenComplete((result, throwable) -> {
            if (ErrorHelper.findWrappedCause(throwable, AsyncTimeoutException.class) != null) {
                dst.retain();
            }
        });
        return future;
    }

    private static <T> CompletableFuture<T> within(CompletableFuture<T> future, long millis) {
        CompletableFuture timeout = new CompletableFuture();
        ScheduledFuture<Boolean> timeoutTask = delayer.schedule(() -> timeout.completeExceptionally(new AsyncTimeoutException()), millis, TimeUnit.MILLISECONDS);
        return ((CompletableFuture)future.applyToEither((CompletionStage)timeout, Function.identity())).whenComplete((x, y) -> timeoutTask.cancel(true));
    }

    @Override
    public void close() throws Exception {
        this.inner.close();
    }

    @Override
    public List<AsyncByteReader.ReaderStat> getStats() {
        return this.inner.getStats();
    }

    static {
        delayer.setRemoveOnCancelPolicy(true);
    }

    private static class AsyncTimeoutException
    extends TimeoutException {
        AsyncTimeoutException() {
        }
    }
}

