/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.exec.proto.GeneralRPCProtos;
import cdjd.com.dremio.exec.rpc.RpcEncoder;
import cdjd.com.dremio.exec.rpc.RpcMessage;
import cdjd.com.google.common.collect.Lists;
import cdjd.com.google.protobuf.Internal;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundRpcMessage
extends RpcMessage {
    static final Logger logger = LoggerFactory.getLogger(OutboundRpcMessage.class);
    final MessageLite pBody;
    final ByteBuf[] dBodies;

    public OutboundRpcMessage(GeneralRPCProtos.RpcMode mode, Internal.EnumLite rpcType, int coordinationId, MessageLite pBody, ByteBuf ... dBodies) {
        this(mode, rpcType.getNumber(), coordinationId, pBody, dBodies);
    }

    OutboundRpcMessage(GeneralRPCProtos.RpcMode mode, int rpcTypeNumber, int coordinationId, MessageLite pBody, ByteBuf ... dBodies) {
        super(mode, rpcTypeNumber, coordinationId);
        this.pBody = pBody;
        ArrayList<ByteBuf> bufs = Lists.newArrayList();
        for (ByteBuf d : dBodies) {
            if (d.readableBytes() == 0) {
                d.release();
                continue;
            }
            bufs.add(d);
        }
        this.dBodies = bufs.toArray(new ByteBuf[bufs.size()]);
    }

    public MessageLite getPBody() {
        return this.pBody;
    }

    public ByteBuf[] getDBodies() {
        return this.dBodies;
    }

    @Override
    public int getBodySize() {
        int len = this.pBody.getSerializedSize();
        len += RpcEncoder.getRawVarintSize(len);
        return len += this.getRawBodySize();
    }

    public int getRawBodySize() {
        int len = 0;
        for (int i = 0; i < this.dBodies.length; ++i) {
            len += this.dBodies[i].readableBytes();
        }
        return len;
    }

    public String toString() {
        return "OutboundRpcMessage [pBody=" + this.pBody + ", mode=" + this.mode + ", rpcType=" + this.rpcType + ", coordinationId=" + this.coordinationId + ", dBodies=" + Arrays.toString(this.dBodies) + "]";
    }

    @Override
    void release() {
        for (ByteBuf b : this.dBodies) {
            b.release();
        }
    }
}

