/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.common.memory.MemoryDebugInfo;
import cdjd.com.dremio.exec.proto.GeneralRPCProtos;
import cdjd.com.dremio.exec.rpc.InboundRpcMessage;
import cdjd.com.dremio.exec.rpc.OutboundRpcMessage;
import cdjd.com.dremio.exec.rpc.RpcEncoder;
import cdjd.com.google.protobuf.CodedInputStream;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.buffer.ByteBufInputStream;
import cdjd.io.netty.buffer.NettyArrowBuf;
import cdjd.io.netty.channel.ChannelFuture;
import cdjd.io.netty.channel.ChannelFutureListener;
import cdjd.io.netty.channel.ChannelHandlerContext;
import cdjd.io.netty.handler.codec.ByteToMessageDecoder;
import cdjd.io.netty.handler.codec.CorruptedFrameException;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.OutOfMemoryException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecoder
extends ByteToMessageDecoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BufferAllocator allocator;
    private final AtomicLong messageCounter = new AtomicLong();

    public MessageDecoder(BufferAllocator allocator) {
        this.setCumulator(COMPOSITE_CUMULATOR);
        this.allocator = allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isOpen()) {
            if (in.readableBytes() > 0) {
                this.logger.info("Channel is closed, discarding remaining {} byte(s) in buffer.", (Object)in.readableBytes());
            }
            in.skipBytes(in.readableBytes());
            return;
        }
        in.markReaderIndex();
        byte[] buf = new byte[5];
        int length = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            buf[i] = in.readByte();
            if (buf[i] < 0) continue;
            length = CodedInputStream.newInstance(buf, 0, i + 1).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (length == 0) {
                throw new CorruptedFrameException("Received a message of length 0.");
            }
            if (in.readableBytes() >= length) break;
            in.resetReaderIndex();
            return;
        }
        ByteBuf frame = in.slice(in.readerIndex(), length);
        try {
            InboundRpcMessage message = this.decodeMessage(ctx, frame, length);
            if (message != null) {
                out.add(message);
            }
        }
        finally {
            in.skipBytes(length);
        }
    }

    private InboundRpcMessage decodeMessage(ChannelHandlerContext ctx, ByteBuf frame, int length) throws Exception {
        ByteBufInputStream is = new ByteBufInputStream(frame, length);
        this.checkTag(is, RpcEncoder.HEADER_TAG);
        GeneralRPCProtos.RpcHeader header = GeneralRPCProtos.RpcHeader.parseDelimitedFrom(is);
        this.checkTag(is, RpcEncoder.PROTOBUF_BODY_TAG);
        int pBodyLength = MessageDecoder.readRawVarint32(is);
        byte[] pBody = new byte[pBodyLength];
        frame.readBytes(pBody);
        NettyArrowBuf dBody = null;
        if (frame.readableBytes() > 0) {
            this.checkTag(is, RpcEncoder.RAW_BODY_TAG);
            int dBodyLength = MessageDecoder.readRawVarint32(is);
            if (frame.readableBytes() != dBodyLength) {
                throw new CorruptedFrameException(String.format("Expected to receive a raw body of %d bytes but received a buffer with %d bytes.", dBodyLength, frame.readableBytes()));
            }
            try {
                dBody = this.allocator.buffer(dBodyLength).asNettyBuffer();
                ((ByteBuf)dBody).writeBytes(frame.nioBuffer(frame.readerIndex(), dBodyLength));
            }
            catch (OutOfMemoryException e) {
                this.sendOutOfMemory(e, ctx, header.getCoordinationId());
                return null;
            }
        }
        InboundRpcMessage m3 = new InboundRpcMessage(header.getMode(), header.getRpcType(), header.getCoordinationId(), pBody, dBody);
        return m3;
    }

    private void sendOutOfMemory(OutOfMemoryException e, ChannelHandlerContext ctx, int coordinationId) {
        UserException uex = UserException.memoryError(e).message("Out of memory while receiving data.", new Object[0]).addContext(MemoryDebugInfo.getDetailsOnAllocationFailure(e, this.allocator)).build(this.logger);
        OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE_FAILURE, 0, coordinationId, (MessageLite)uex.getOrCreatePBError(false), new ByteBuf[0]);
        ChannelFuture future = ctx.writeAndFlush(outMessage);
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    private void checkTag(ByteBufInputStream is, int expectedTag) throws IOException {
        int actualTag = MessageDecoder.readRawVarint32(is);
        if (actualTag != expectedTag) {
            throw new CorruptedFrameException(String.format("Expected to read a tag of %d but actually received a value of %d.  Happened after reading %d message.", expectedTag, actualTag, this.messageCounter.get()));
        }
    }

    public static int readRawVarint32(ByteBufInputStream is) throws IOException {
        byte tmp = is.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = is.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = is.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = is.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = is.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (is.readByte() < 0) continue;
                            return result;
                        }
                        throw new CorruptedFrameException("Encountered a malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }
}

