/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.exec.rpc.ConnectionFailedException;
import cdjd.com.dremio.exec.rpc.RemoteConnection;
import cdjd.com.dremio.exec.rpc.RpcCommand;
import cdjd.com.dremio.exec.rpc.RpcConnectionHandler;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcOutcomeListener;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListeningCommand<T extends MessageLite, C extends RemoteConnection>
implements RpcCommand<T, C> {
    static final Logger logger = LoggerFactory.getLogger(ListeningCommand.class);
    private final RpcOutcomeListener<T> listener;

    public ListeningCommand(RpcOutcomeListener<T> listener) {
        this.listener = listener;
    }

    public abstract void doRpcCall(RpcOutcomeListener<T> var1, C var2);

    @Override
    public void connectionAvailable(C connection) {
        this.doRpcCall(new DeferredRpcOutcome(), connection);
    }

    @Override
    public void connectionSucceeded(C connection) {
        this.connectionAvailable(connection);
    }

    @Override
    public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
        this.listener.failed(ConnectionFailedException.mapException(RpcException.mapException(String.format("Command failed while establishing connection.  Failure type %s.", new Object[]{type}), t), type));
    }

    private class DeferredRpcOutcome
    implements RpcOutcomeListener<T> {
        private DeferredRpcOutcome() {
        }

        @Override
        public void failed(RpcException ex) {
            ListeningCommand.this.listener.failed(ex);
        }

        @Override
        public void success(T value, ByteBuf buf) {
            ListeningCommand.this.listener.success(value, buf);
        }

        @Override
        public void interrupted(InterruptedException e) {
            ListeningCommand.this.listener.interrupted(e);
        }
    }
}

