/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.record;

import cdjd.com.dremio.common.util.Numbers;
import cdjd.com.dremio.exec.expr.TypeHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.record.BatchSchema;
import cdjd.com.dremio.exec.record.VectorAccessible;
import cdjd.com.dremio.exec.record.VectorContainer;
import cdjd.com.dremio.exec.record.VectorWrapper;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.Lists;
import cdjd.io.netty.buffer.NettyArrowBuf;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.ValueVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class WritableBatch
implements AutoCloseable {
    private final UserBitShared.RecordBatchDef def;
    private final ArrowBuf[] buffers;
    private boolean cleared = false;

    private WritableBatch(UserBitShared.RecordBatchDef def, List<ArrowBuf> buffers) {
        this.def = def;
        this.buffers = buffers.toArray(new ArrowBuf[buffers.size()]);
    }

    private WritableBatch(UserBitShared.RecordBatchDef def, ArrowBuf[] buffers) {
        this.def = def;
        this.buffers = buffers;
    }

    public WritableBatch transfer(BufferAllocator allocator) {
        ArrayList<ArrowBuf> newBuffers = Lists.newArrayList();
        for (ArrowBuf buf : this.buffers) {
            long writerIndex = buf.writerIndex();
            ArrowBuf newBuf = buf.getReferenceManager().transferOwnership(buf, allocator).getTransferredBuffer();
            newBuf.writerIndex(writerIndex);
            newBuffers.add(newBuf);
        }
        this.clear();
        return new WritableBatch(this.def, newBuffers);
    }

    public UserBitShared.RecordBatchDef getDef() {
        return this.def;
    }

    public NettyArrowBuf[] getBuffers() {
        NettyArrowBuf[] nettyBuffers = new NettyArrowBuf[this.buffers.length];
        return Arrays.stream(this.buffers).map(buf -> buf.asNettyBuffer()).collect(Collectors.toList()).toArray(nettyBuffers);
    }

    public int getLength() {
        long length = 0L;
        List<UserBitShared.SerializedField> fields = this.def.getFieldList();
        for (UserBitShared.SerializedField field : fields) {
            int dataLength = field.getBufferLength();
            length += (long)Numbers.nextPowerOfTwo(dataLength);
        }
        return (int)length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstructContainer(BufferAllocator allocator, VectorContainer container) {
        Preconditions.checkState(!this.cleared, "Attempted to reconstruct a container from a WritableBatch after it had been cleared");
        if (this.buffers.length > 0) {
            int len = 0;
            for (ArrowBuf b : this.buffers) {
                len = (int)((long)len + b.capacity());
            }
            ArrowBuf newBuf = allocator.buffer(len);
            try {
                int offset = 0;
                for (ArrowBuf buf : this.buffers) {
                    newBuf.setBytes((long)offset, buf);
                    offset = (int)((long)offset + buf.capacity());
                    buf.release();
                }
                List<UserBitShared.SerializedField> fields = this.def.getFieldList();
                int bufferOffset = 0;
                int vectorIndex = 0;
                for (VectorWrapper<?> vv : container) {
                    UserBitShared.SerializedField fmd = fields.get(vectorIndex);
                    Object v = vv.getValueVector();
                    ArrowBuf bb = newBuf.slice(bufferOffset, fmd.getBufferLength());
                    TypeHelper.load(v, fmd, bb);
                    ++vectorIndex;
                    bufferOffset += fmd.getBufferLength();
                }
            }
            finally {
                newBuf.release(1);
            }
        }
        BatchSchema.SelectionVectorMode svMode = this.def.hasCarriesTwoByteSelectionVector() && this.def.getCarriesTwoByteSelectionVector() ? BatchSchema.SelectionVectorMode.TWO_BYTE : BatchSchema.SelectionVectorMode.NONE;
        container.buildSchema(svMode);
        for (VectorWrapper v : container) {
            v.getValueVector().setValueCount(this.def.getRecordCount());
        }
    }

    public void clear() {
        if (this.cleared) {
            return;
        }
        for (ArrowBuf buf : this.buffers) {
            buf.release();
        }
        this.cleared = true;
    }

    public static WritableBatch getBatchNoHVWrap(int recordCount, Iterable<VectorWrapper<?>> vws, boolean isSV2) {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper<?> vw : vws) {
            Preconditions.checkArgument(!vw.isHyper());
            vectors.add((ValueVector)vw.getValueVector());
        }
        return WritableBatch.getBatchNoHV(recordCount, vectors, isSV2);
    }

    public static WritableBatch getBatchNoHV(int recordCount, Iterable<ValueVector> vectors, boolean isSV2) {
        ArrayList<ArrowBuf> buffers = Lists.newArrayList();
        ArrayList<UserBitShared.SerializedField> metadata = Lists.newArrayList();
        for (ValueVector vv : vectors) {
            metadata.add(TypeHelper.getMetadata(vv));
            if (recordCount == 0) {
                vv.clear();
                continue;
            }
            for (ArrowBuf b : vv.getBuffers(true)) {
                buffers.add(b);
            }
            vv.clear();
        }
        UserBitShared.RecordBatchDef batchDef = UserBitShared.RecordBatchDef.newBuilder().addAllField(metadata).setRecordCount(recordCount).setCarriesTwoByteSelectionVector(isSV2).build();
        WritableBatch b = new WritableBatch(batchDef, buffers);
        return b;
    }

    private static void validate(WritableBatch b) {
        for (UserBitShared.SerializedField f : b.getDef().getFieldList()) {
            if (!f.hasNamePart()) {
                throw new RuntimeException("Field is missing name");
            }
            if (!f.getNamePart().getName().equals("")) continue;
            throw new RuntimeException("Field name is empty");
        }
    }

    public static WritableBatch get(VectorAccessible batch) {
        if (batch.getSchema() != null && batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            throw new UnsupportedOperationException("Only batches without hyper selections vectors are writable.");
        }
        boolean sv2 = batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(batch.getRecordCount(), batch, sv2);
    }

    public void retainBuffers(int increment) {
        for (ArrowBuf buf : this.buffers) {
            buf.retain(increment);
        }
    }

    @Override
    public void close() {
        this.clear();
    }
}

