/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.record;

import cdjd.com.dremio.common.expression.BasePath;
import cdjd.com.dremio.exec.record.TypedFieldId;
import cdjd.com.dremio.exec.record.VectorWrapper;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.AbstractStructVector;
import cdjd.org.apache.arrow.vector.complex.FieldIdUtil2;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.util.CallBack;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVectorWrapper<T extends ValueVector>
implements VectorWrapper<T> {
    static final Logger logger = LoggerFactory.getLogger(SimpleVectorWrapper.class);
    private T vector;

    public SimpleVectorWrapper(T v) {
        this.vector = v;
    }

    @Override
    public Class<T> getVectorClass() {
        return this.vector.getClass();
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public T getValueVector() {
        return this.vector;
    }

    @Override
    public T[] getValueVectors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHyper() {
        return false;
    }

    @Override
    public VectorWrapper<T> cloneAndTransfer(BufferAllocator allocator, CallBack callback) {
        TransferPair tp = this.vector.getTransferPair(this.vector.getField().getName(), allocator, callback);
        tp.transfer();
        return new SimpleVectorWrapper<ValueVector>(tp.getTo());
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    public static <T extends ValueVector> SimpleVectorWrapper<T> create(T v) {
        return new SimpleVectorWrapper<T>(v);
    }

    @Override
    public VectorWrapper<?> getChildWrapper(int[] ids) {
        if (ids.length == 1) {
            return this;
        }
        Object vector = this.vector;
        for (int i = 1; i < ids.length; ++i) {
            AbstractStructVector mapLike = (AbstractStructVector)AbstractStructVector.class.cast(vector);
            if (mapLike == null) {
                return null;
            }
            vector = mapLike.getChildByOrdinal(ids[i]);
        }
        return new SimpleVectorWrapper<T>(vector);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(int id, BasePath expectedPath) {
        return FieldIdUtil2.getFieldId(this.getValueVector().getField(), id, expectedPath, true);
    }

    @Override
    public void transfer(VectorWrapper<?> destination) {
        Preconditions.checkArgument(destination instanceof SimpleVectorWrapper);
        Preconditions.checkArgument(this.getField().getType().equals(destination.getField().getType()));
        this.vector.makeTransferPair((ValueVector)((SimpleVectorWrapper)destination).vector).transfer();
    }
}

