/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.record;

import cdjd.com.dremio.common.expression.BasePath;
import cdjd.com.dremio.exec.record.BatchSchema;
import cdjd.com.dremio.exec.record.TypedFieldId;
import cdjd.com.dremio.exec.record.VectorAccessible;
import cdjd.com.dremio.exec.record.VectorContainer;
import cdjd.com.dremio.exec.record.VectorWrapper;
import cdjd.com.dremio.exec.record.WritableBatch;
import cdjd.com.dremio.exec.record.selection.SelectionVector2;
import cdjd.com.dremio.exec.record.selection.SelectionVector4;
import cdjd.com.dremio.sabot.op.receiver.RawFragmentBatch;
import cdjd.com.google.common.base.Function;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.FluentIterable;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.org.apache.arrow.flatbuf.Buffer;
import cdjd.org.apache.arrow.flatbuf.FieldNode;
import cdjd.org.apache.arrow.flatbuf.RecordBatch;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.util.LargeMemoryUtil;
import cdjd.org.apache.arrow.vector.AllocationHelper;
import cdjd.org.apache.arrow.vector.BufferLayout;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.TypeLayout;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowRecordBatchLoader
implements VectorAccessible,
Iterable<VectorWrapper<?>>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ArrowRecordBatchLoader.class);
    private VectorContainer container;
    private int valueCount;
    private BatchSchema schema;

    public ArrowRecordBatchLoader(VectorContainer container) {
        this.container = container;
        this.schema = container.getSchema();
    }

    public ArrowRecordBatchLoader(BufferAllocator allocator, BatchSchema schema) {
        Preconditions.checkNotNull(allocator);
        this.schema = schema;
        this.container = VectorContainer.create(allocator, schema);
    }

    public int load(RawFragmentBatch batch) {
        this.container.zeroVectors();
        int size = 0;
        try {
            RecordBatch recordBatch = RecordBatch.getRootAsRecordBatch(batch.getHeader().getArrowRecordBatch().asReadOnlyByteBuffer());
            if (batch.getBody() == null) {
                for (VectorWrapper<?> w : this.container) {
                    AllocationHelper.allocate(w.getValueVector(), 0, 0, 0);
                }
                this.container.setRecordCount(0);
            }
            if (recordBatch.length() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("record batch length too big: " + recordBatch.length());
            }
            this.valueCount = (int)recordBatch.length();
            if (this.valueCount == 0) {
                return 0;
            }
            size = batch.getBody() == null ? 0 : LargeMemoryUtil.checkedCastToInt(batch.getBody().readableBytes());
            ArrowRecordBatchLoader.load(recordBatch, this.container, batch.getBody());
        }
        catch (Throwable cause) {
            this.container.zeroVectors();
            throw cause;
        }
        this.container.setRecordCount(this.valueCount);
        return size;
    }

    public static ArrowRecordBatch deserializeRecordBatch(RecordBatch recordBatchFB, ArrowBuf body) throws IOException {
        int nodesLength = recordBatchFB.nodesLength();
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        for (int i = 0; i < nodesLength; ++i) {
            FieldNode node = recordBatchFB.nodes(i);
            if ((long)((int)node.length()) != node.length() || (long)((int)node.nullCount()) != node.nullCount()) {
                throw new IOException("Cannot currently deserialize record batches with node length larger than Int.MAX_VALUE");
            }
            nodes.add(new ArrowFieldNode((int)node.length(), (int)node.nullCount()));
        }
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (int i = 0; i < recordBatchFB.buffersLength(); ++i) {
            Buffer bufferFB = recordBatchFB.buffers(i);
            ArrowBuf vectorBuffer = body.slice((int)bufferFB.offset(), (int)bufferFB.length());
            buffers.add(vectorBuffer);
        }
        if ((long)((int)recordBatchFB.length()) != recordBatchFB.length()) {
            throw new IOException("Cannot currently deserialize record batches over 2GB");
        }
        ArrowRecordBatch arrowRecordBatch = new ArrowRecordBatch((int)recordBatchFB.length(), nodes, buffers, false);
        for (ArrowBuf buf : buffers) {
            buf.release();
        }
        return arrowRecordBatch;
    }

    public static void load(RecordBatch recordBatch, VectorAccessible vectorAccessible, ArrowBuf body) {
        List<Field> fields = vectorAccessible.getSchema().getFields();
        ImmutableList fieldVectors = FluentIterable.from(vectorAccessible).transform(new Function<VectorWrapper<?>, FieldVector>(){

            @Override
            public FieldVector apply(VectorWrapper<?> wrapper) {
                return (FieldVector)wrapper.getValueVector();
            }
        }).toList();
        try {
            ArrowRecordBatch arrowRecordBatch = ArrowRecordBatchLoader.deserializeRecordBatch(recordBatch, body);
            Iterator<ArrowFieldNode> nodes = arrowRecordBatch.getNodes().iterator();
            Iterator<ArrowBuf> buffers = arrowRecordBatch.getBuffers().iterator();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                FieldVector fieldVector = (FieldVector)fieldVectors.get(i);
                ArrowRecordBatchLoader.loadBuffers(fieldVector, field, buffers, nodes);
            }
            if (buffers.hasNext()) {
                throw new IllegalArgumentException("not all buffers were consumed. " + buffers);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("could not deserialize batch for " + vectorAccessible.getSchema(), e);
        }
    }

    private static void loadBuffers(FieldVector vector, Field field, Iterator<ArrowBuf> buffers, Iterator<ArrowFieldNode> nodes) {
        Preconditions.checkArgument(nodes.hasNext(), "no more field nodes for for field %s and vector %s", (Object)field, (Object)vector);
        ArrowFieldNode fieldNode = nodes.next();
        List<BufferLayout> bufferLayouts = TypeLayout.getTypeLayout(field.getType()).getBufferLayouts();
        ArrayList<ArrowBuf> ownBuffers = new ArrayList<ArrowBuf>(bufferLayouts.size());
        for (int j = 0; j < bufferLayouts.size(); ++j) {
            ownBuffers.add(buffers.next());
        }
        try {
            vector.loadFieldBuffers(fieldNode, ownBuffers);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load buffers for field " + field + ". error message: " + e.getMessage(), e);
        }
        List<Field> children = field.getChildren();
        if (children.size() > 0) {
            List<FieldVector> childrenFromFields = vector.getChildrenFromFields();
            Preconditions.checkArgument(children.size() == childrenFromFields.size(), "should have as many children as in the schema: found " + childrenFromFields.size() + " expected " + children.size());
            for (int i = 0; i < childrenFromFields.size(); ++i) {
                Field child = children.get(i);
                FieldVector fieldVector = childrenFromFields.get(i);
                ArrowRecordBatchLoader.loadBuffers(fieldVector, child, buffers, nodes);
            }
        }
    }

    @Override
    public TypedFieldId getValueVectorId(BasePath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public int getRecordCount() {
        return this.valueCount;
    }

    @Override
    public <T extends ValueVector> VectorWrapper<T> getValueAccessorById(Class<T> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    public WritableBatch getWritableBatch() {
        boolean isSV2 = this.schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(this.valueCount, this.container, isSV2);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    public void resetRecordCount() {
        this.valueCount = 0;
    }

    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        this.container.clear();
        this.resetRecordCount();
    }
}

