/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.expr;

import cdjd.com.dremio.common.util.MajorTypeHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.vector.BaseFixedWidthVector;
import cdjd.org.apache.arrow.vector.BaseVariableWidthVector;
import cdjd.org.apache.arrow.vector.FixedWidthVectorHelper;
import cdjd.org.apache.arrow.vector.NullVector;
import cdjd.org.apache.arrow.vector.NullVectorHelper;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.ValueVectorHelper;
import cdjd.org.apache.arrow.vector.VariableWidthVectorHelper;
import cdjd.org.apache.arrow.vector.ZeroVector;
import cdjd.org.apache.arrow.vector.ZeroVectorHelper;
import cdjd.org.apache.arrow.vector.complex.ListVector;
import cdjd.org.apache.arrow.vector.complex.ListVectorHelper;
import cdjd.org.apache.arrow.vector.complex.NonNullableStructVector;
import cdjd.org.apache.arrow.vector.complex.NonNullableStructVectorHelper;
import cdjd.org.apache.arrow.vector.complex.StructVector;
import cdjd.org.apache.arrow.vector.complex.StructVectorHelper;
import cdjd.org.apache.arrow.vector.complex.UnionVector;
import cdjd.org.apache.arrow.vector.complex.UnionVectorHelper;
import cdjd.org.apache.arrow.vector.holders.BigIntHolder;
import cdjd.org.apache.arrow.vector.holders.BitHolder;
import cdjd.org.apache.arrow.vector.holders.DateMilliHolder;
import cdjd.org.apache.arrow.vector.holders.DecimalHolder;
import cdjd.org.apache.arrow.vector.holders.FixedSizeBinaryHolder;
import cdjd.org.apache.arrow.vector.holders.Float4Holder;
import cdjd.org.apache.arrow.vector.holders.Float8Holder;
import cdjd.org.apache.arrow.vector.holders.IntHolder;
import cdjd.org.apache.arrow.vector.holders.IntervalDayHolder;
import cdjd.org.apache.arrow.vector.holders.IntervalYearHolder;
import cdjd.org.apache.arrow.vector.holders.NullableBigIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableBitHolder;
import cdjd.org.apache.arrow.vector.holders.NullableDateMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableDecimalHolder;
import cdjd.org.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;
import cdjd.org.apache.arrow.vector.holders.NullableFloat4Holder;
import cdjd.org.apache.arrow.vector.holders.NullableFloat8Holder;
import cdjd.org.apache.arrow.vector.holders.NullableIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import cdjd.org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import cdjd.org.apache.arrow.vector.holders.NullableSmallIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTinyIntHolder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt1Holder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt2Holder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt4Holder;
import cdjd.org.apache.arrow.vector.holders.NullableUInt8Holder;
import cdjd.org.apache.arrow.vector.holders.NullableVarBinaryHolder;
import cdjd.org.apache.arrow.vector.holders.NullableVarCharHolder;
import cdjd.org.apache.arrow.vector.holders.SmallIntHolder;
import cdjd.org.apache.arrow.vector.holders.TimeMilliHolder;
import cdjd.org.apache.arrow.vector.holders.TimeStampMilliHolder;
import cdjd.org.apache.arrow.vector.holders.TinyIntHolder;
import cdjd.org.apache.arrow.vector.holders.UInt1Holder;
import cdjd.org.apache.arrow.vector.holders.UInt2Holder;
import cdjd.org.apache.arrow.vector.holders.UInt4Holder;
import cdjd.org.apache.arrow.vector.holders.UInt8Holder;
import cdjd.org.apache.arrow.vector.holders.ValueHolder;
import cdjd.org.apache.arrow.vector.holders.VarBinaryHolder;
import cdjd.org.apache.arrow.vector.holders.VarCharHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.UnionMode;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.util.BasicTypeHelper;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeHelper
extends BasicTypeHelper {
    static final Logger logger = LoggerFactory.getLogger(TypeHelper.class);

    public static <T extends ValueVector> Class<T> getValueVectorClass(Field field) {
        return TypeHelper.getValueVectorClass(Types.getMinorTypeForArrowType(field.getType()));
    }

    public static void load(ValueVector v, UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        Optional<ValueVectorHelper> helper = TypeHelper.getHelper(v);
        if (!helper.isPresent()) {
            throw new UnsupportedOperationException(String.format("no loader for vector %s", v));
        }
        helper.get().load(metadata, buffer);
    }

    public static void loadFromValidityAndDataBuffers(ValueVector v, UserBitShared.SerializedField metadata, ArrowBuf dataBuffer, ArrowBuf validityBuffer) {
        if (v instanceof ZeroVector) {
            throw new UnsupportedOperationException(String.format("this loader is not supported for vector %s", v));
        }
        if (v instanceof UnionVector) {
            throw new UnsupportedOperationException(String.format("this loader is not supported for vector %s", v));
        }
        if (v instanceof ListVector) {
            throw new UnsupportedOperationException(String.format("this loader is not supported for vector %s", v));
        }
        if (v instanceof StructVector) {
            throw new UnsupportedOperationException(String.format("this loader is not supported for vector %s", v));
        }
        if (v instanceof NonNullableStructVector) {
            throw new UnsupportedOperationException(String.format("this loader is not supported for vector %s", v));
        }
        Optional<ValueVectorHelper> helper = TypeHelper.getHelper(v);
        if (!helper.isPresent()) {
            throw new UnsupportedOperationException(String.format("no loader for vector %s", v));
        }
        helper.get().loadFromValidityAndDataBuffers(metadata, dataBuffer, validityBuffer);
    }

    public static void loadData(ValueVector v, UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        Optional<ValueVectorHelper> helper = TypeHelper.getHelper(v);
        if (!helper.isPresent()) {
            throw new UnsupportedOperationException(String.format("no loader for vector %s", v));
        }
        helper.get().loadData(metadata, buffer);
    }

    public static UserBitShared.SerializedField.Builder getMetadataBuilder(ValueVector v) {
        return TypeHelper.getHelper(v).map(t -> t.getMetadataBuilder()).orElse(null);
    }

    public static Optional<ValueVectorHelper> getHelper(ValueVector v) {
        return Optional.ofNullable(TypeHelper.getHelperNull(v));
    }

    private static ValueVectorHelper getHelperNull(ValueVector v) {
        if (v instanceof ZeroVector) {
            return new ZeroVectorHelper((ZeroVector)v);
        }
        if (v instanceof NullVector) {
            return new NullVectorHelper((NullVector)v);
        }
        if (v instanceof UnionVector) {
            return new UnionVectorHelper((UnionVector)v);
        }
        if (v instanceof ListVector) {
            return new ListVectorHelper((ListVector)v);
        }
        if (v instanceof StructVector) {
            return new StructVectorHelper((StructVector)v);
        }
        if (v instanceof NonNullableStructVector) {
            return new NonNullableStructVectorHelper((NonNullableStructVector)v);
        }
        if (v instanceof BaseFixedWidthVector) {
            return new FixedWidthVectorHelper<BaseFixedWidthVector>((BaseFixedWidthVector)v);
        }
        if (v instanceof BaseVariableWidthVector) {
            return new VariableWidthVectorHelper<BaseVariableWidthVector>((BaseVariableWidthVector)v);
        }
        return null;
    }

    public static UserBitShared.SerializedField getMetadata(ValueVector v) {
        return TypeHelper.getHelper(v).map(t -> t.getMetadata()).orElse(null);
    }

    public static ValueHolder getRequiredHolder(ValueHolder h2) {
        if (h2 instanceof NullableTinyIntHolder) {
            NullableTinyIntHolder holder = (NullableTinyIntHolder)h2;
            TinyIntHolder TinyIntHolder2 = new TinyIntHolder();
            TinyIntHolder2.value = holder.value;
            return TinyIntHolder2;
        }
        if (h2 instanceof NullableUInt1Holder) {
            NullableUInt1Holder holder = (NullableUInt1Holder)h2;
            UInt1Holder UInt1Holder2 = new UInt1Holder();
            UInt1Holder2.value = holder.value;
            return UInt1Holder2;
        }
        if (h2 instanceof NullableUInt2Holder) {
            NullableUInt2Holder holder = (NullableUInt2Holder)h2;
            UInt2Holder UInt2Holder2 = new UInt2Holder();
            UInt2Holder2.value = holder.value;
            return UInt2Holder2;
        }
        if (h2 instanceof NullableSmallIntHolder) {
            NullableSmallIntHolder holder = (NullableSmallIntHolder)h2;
            SmallIntHolder SmallIntHolder2 = new SmallIntHolder();
            SmallIntHolder2.value = holder.value;
            return SmallIntHolder2;
        }
        if (h2 instanceof NullableIntHolder) {
            NullableIntHolder holder = (NullableIntHolder)h2;
            IntHolder IntHolder2 = new IntHolder();
            IntHolder2.value = holder.value;
            return IntHolder2;
        }
        if (h2 instanceof NullableUInt4Holder) {
            NullableUInt4Holder holder = (NullableUInt4Holder)h2;
            UInt4Holder UInt4Holder2 = new UInt4Holder();
            UInt4Holder2.value = holder.value;
            return UInt4Holder2;
        }
        if (h2 instanceof NullableFloat4Holder) {
            NullableFloat4Holder holder = (NullableFloat4Holder)h2;
            Float4Holder Float4Holder2 = new Float4Holder();
            Float4Holder2.value = holder.value;
            return Float4Holder2;
        }
        if (h2 instanceof NullableIntervalYearHolder) {
            NullableIntervalYearHolder holder = (NullableIntervalYearHolder)h2;
            IntervalYearHolder IntervalYearHolder2 = new IntervalYearHolder();
            IntervalYearHolder2.value = holder.value;
            return IntervalYearHolder2;
        }
        if (h2 instanceof NullableTimeMilliHolder) {
            NullableTimeMilliHolder holder = (NullableTimeMilliHolder)h2;
            TimeMilliHolder TimeMilliHolder2 = new TimeMilliHolder();
            TimeMilliHolder2.value = holder.value;
            return TimeMilliHolder2;
        }
        if (h2 instanceof NullableBigIntHolder) {
            NullableBigIntHolder holder = (NullableBigIntHolder)h2;
            BigIntHolder BigIntHolder2 = new BigIntHolder();
            BigIntHolder2.value = holder.value;
            return BigIntHolder2;
        }
        if (h2 instanceof NullableUInt8Holder) {
            NullableUInt8Holder holder = (NullableUInt8Holder)h2;
            UInt8Holder UInt8Holder2 = new UInt8Holder();
            UInt8Holder2.value = holder.value;
            return UInt8Holder2;
        }
        if (h2 instanceof NullableFloat8Holder) {
            NullableFloat8Holder holder = (NullableFloat8Holder)h2;
            Float8Holder Float8Holder2 = new Float8Holder();
            Float8Holder2.value = holder.value;
            return Float8Holder2;
        }
        if (h2 instanceof NullableDateMilliHolder) {
            NullableDateMilliHolder holder = (NullableDateMilliHolder)h2;
            DateMilliHolder DateMilliHolder2 = new DateMilliHolder();
            DateMilliHolder2.value = holder.value;
            return DateMilliHolder2;
        }
        if (h2 instanceof NullableTimeStampMilliHolder) {
            NullableTimeStampMilliHolder holder = (NullableTimeStampMilliHolder)h2;
            TimeStampMilliHolder TimeStampMilliHolder2 = new TimeStampMilliHolder();
            TimeStampMilliHolder2.value = holder.value;
            return TimeStampMilliHolder2;
        }
        if (h2 instanceof NullableIntervalDayHolder) {
            NullableIntervalDayHolder holder = (NullableIntervalDayHolder)h2;
            IntervalDayHolder IntervalDayHolder2 = new IntervalDayHolder();
            IntervalDayHolder2.days = holder.days;
            IntervalDayHolder2.milliseconds = holder.milliseconds;
            return IntervalDayHolder2;
        }
        if (h2 instanceof NullableDecimalHolder) {
            NullableDecimalHolder holder = (NullableDecimalHolder)h2;
            DecimalHolder DecimalHolder2 = new DecimalHolder();
            DecimalHolder2.start = holder.start;
            DecimalHolder2.buffer = holder.buffer;
            DecimalHolder2.scale = holder.scale;
            DecimalHolder2.precision = holder.precision;
            return DecimalHolder2;
        }
        if (h2 instanceof NullableFixedSizeBinaryHolder) {
            NullableFixedSizeBinaryHolder holder = (NullableFixedSizeBinaryHolder)h2;
            FixedSizeBinaryHolder FixedSizeBinaryHolder2 = new FixedSizeBinaryHolder();
            FixedSizeBinaryHolder2.buffer = holder.buffer;
            FixedSizeBinaryHolder2.byteWidth = holder.byteWidth;
            return FixedSizeBinaryHolder2;
        }
        if (h2 instanceof NullableVarBinaryHolder) {
            NullableVarBinaryHolder holder = (NullableVarBinaryHolder)h2;
            VarBinaryHolder VarBinaryHolder2 = new VarBinaryHolder();
            VarBinaryHolder2.start = holder.start;
            VarBinaryHolder2.end = holder.end;
            VarBinaryHolder2.buffer = holder.buffer;
            return VarBinaryHolder2;
        }
        if (h2 instanceof NullableVarCharHolder) {
            NullableVarCharHolder holder = (NullableVarCharHolder)h2;
            VarCharHolder VarCharHolder2 = new VarCharHolder();
            VarCharHolder2.start = holder.start;
            VarCharHolder2.end = holder.end;
            VarCharHolder2.buffer = holder.buffer;
            return VarCharHolder2;
        }
        if (h2 instanceof NullableBitHolder) {
            NullableBitHolder holder = (NullableBitHolder)h2;
            BitHolder BitHolder2 = new BitHolder();
            BitHolder2.value = holder.value;
            return BitHolder2;
        }
        return h2;
    }

    public static Field getFieldForSerializedField(UserBitShared.SerializedField serializedField) {
        String name = serializedField.getNamePart().getName();
        Types.MinorType arrowMinorType = MajorTypeHelper.getArrowMinorType(serializedField.getMajorType().getMinorType());
        switch (serializedField.getMajorType().getMinorType()) {
            case LIST: {
                return new Field(name, true, arrowMinorType.getType(), ImmutableList.of(TypeHelper.getFieldForSerializedField(serializedField.getChild(2))));
            }
            case STRUCT: {
                ImmutableList.Builder builder = ImmutableList.builder();
                List<UserBitShared.SerializedField> childList = serializedField.getChildList();
                Preconditions.checkState(childList.size() > 0, "children should start with validity vector buffer");
                UserBitShared.SerializedField bits = childList.get(0);
                Preconditions.checkState(bits.getNamePart().getName().equals("$bits$"), "children should start with validity vector buffer: %s", childList);
                for (int i = 1; i < childList.size(); ++i) {
                    UserBitShared.SerializedField child = childList.get(i);
                    builder.add(TypeHelper.getFieldForSerializedField(child));
                }
                return new Field(name, true, arrowMinorType.getType(), (List<Field>)((Object)builder.build()));
            }
            case UNION: {
                ImmutableList.Builder builder = ImmutableList.builder();
                List<UserBitShared.SerializedField> unionChilds = serializedField.getChild(1).getChildList();
                int[] typeIds = new int[unionChilds.size()];
                for (int i = 0; i < unionChilds.size(); ++i) {
                    Field childField = TypeHelper.getFieldForSerializedField(unionChilds.get(i));
                    builder.add(childField);
                    typeIds[i] = Types.getMinorTypeForArrowType(childField.getType()).ordinal();
                }
                ArrowType.Union unionType = new ArrowType.Union(UnionMode.Sparse, typeIds);
                return new Field(name, true, unionType, (List<Field>)((Object)builder.build()));
            }
            case DECIMAL: {
                return new Field(name, true, new ArrowType.Decimal(serializedField.getMajorType().getPrecision(), serializedField.getMajorType().getScale()), null);
            }
        }
        return new Field(name, true, arrowMinorType.getType(), null);
    }
}

