/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils;

import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.com.fasterxml.jackson.core.JsonParser;
import cdjd.com.fasterxml.jackson.databind.Module;
import cdjd.com.fasterxml.jackson.databind.ObjectMapper;
import cdjd.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import cdjd.com.fasterxml.jackson.databind.SerializationFeature;
import cdjd.com.google.common.base.Ascii;
import cdjd.com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import java.io.IOException;
import java.io.OutputStream;

public final class ProtobufUtils {
    public static final PropertyNamingStrategy PROTOBUF_TO_CAMEL_STRATEGY = new PropertyNamingStrategy.PropertyNamingStrategyBase(){

        @Override
        public String translate(String propertyName) {
            if (propertyName == null || propertyName.isEmpty()) {
                return propertyName;
            }
            StringBuilder buffer = new StringBuilder(propertyName.length());
            buffer.append(Ascii.toLowerCase(propertyName.charAt(0)));
            boolean toCapitalize = false;
            for (int i = 1; i < propertyName.length(); ++i) {
                char c = propertyName.charAt(i);
                if (c == '_') {
                    toCapitalize = true;
                    continue;
                }
                if (toCapitalize) {
                    buffer.append(Ascii.toUpperCase(c));
                    toCapitalize = false;
                    continue;
                }
                buffer.append(c);
            }
            return buffer.toString();
        }
    };
    private static final ObjectMapper MAPPER = ProtobufUtils.newMapper().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);

    private ProtobufUtils() {
    }

    public static final ObjectMapper newMapper() {
        return new ObjectMapper().enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS).enable(SerializationFeature.WRITE_ENUMS_USING_INDEX).disable(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS).setPropertyNamingStrategy(PROTOBUF_TO_CAMEL_STRATEGY).registerModule((Module)new ProtobufModule());
    }

    public static final <M extends MessageOrBuilder> void writeAsJSONTo(OutputStream os, M value) throws IOException {
        MAPPER.writeValue(os, value);
    }

    public static final <M extends MessageOrBuilder> byte[] toJSONByteArray(M value) throws IOException {
        return MAPPER.writeValueAsBytes(value);
    }

    public static final <M extends MessageOrBuilder> String toJSONString(M value) throws IOException {
        return MAPPER.writeValueAsString(value);
    }

    public static final <M extends MessageOrBuilder> M fromJSONString(Class<M> clazz, String json) throws IOException {
        return (M)((MessageOrBuilder)MAPPER.readValue(json, clazz));
    }
}

