/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils;

import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.common.utils.SqlUtils;
import cdjd.com.dremio.io.file.Path;
import cdjd.com.google.common.base.Joiner;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.Lists;
import cdjd.org.apache.commons.lang3.text.StrTokenizer;
import com.github.slugify.Slugify;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger logger = LoggerFactory.getLogger(PathUtils.class);
    private static final char PATH_DELIMITER = '.';
    private static final Joiner KEY_JOINER = Joiner.on('.').useForNull("");
    private static final String SLASH = "/";
    private static final char SLASH_CHAR = '/';
    private static final Joiner PATH_JOINER = Joiner.on('/').useForNull("");
    private static final Path ROOT_PATH = Path.of("/");
    private static final List<String> EMPTY_SCHEMA_PATHS = Collections.emptyList();
    private static Pattern pattern1 = Pattern.compile("\\%28");
    private static Pattern pattern2 = Pattern.compile("\\%29");
    private static Pattern pattern3 = Pattern.compile("\\+");
    private static Pattern pattern4 = Pattern.compile("\\%27");
    private static Pattern pattern5 = Pattern.compile("\\%21");
    private static Pattern pattern6 = Pattern.compile("\\%7E");

    public static Path toFSPath(List<String> schemaPath) {
        if (schemaPath == null || schemaPath.isEmpty()) {
            return ROOT_PATH;
        }
        return ROOT_PATH.resolve(PATH_JOINER.join(schemaPath));
    }

    public static String toFSPathString(List<String> schemaPath) {
        return Path.withoutSchemeAndAuthority(PathUtils.toFSPath(schemaPath)).toString();
    }

    public static Path toFSPathSkipRoot(List<String> schemaPath, String root) {
        if (schemaPath == null || schemaPath.isEmpty()) {
            return ROOT_PATH;
        }
        if (root == null || !root.equals(schemaPath.get(0))) {
            return PathUtils.toFSPath(schemaPath);
        }
        return PathUtils.toFSPath(schemaPath.subList(1, schemaPath.size()));
    }

    public static Path toFSPath(String path) {
        ArrayList<String> pathComponents = Lists.newArrayList();
        for (String component : PathUtils.parseFullPath(path)) {
            if (component.contains(SLASH)) {
                pathComponents.addAll(PathUtils.toPathComponents(Path.of(component)));
                continue;
            }
            pathComponents.add(component);
        }
        return PathUtils.toFSPath(pathComponents);
    }

    public static String getQuotedFileName(Path path) {
        List<String> components = PathUtils.toPathComponents(path);
        return String.format("%1$s%2$s%1$s", Character.valueOf(SqlUtils.QUOTE), components.get(components.size() - 1));
    }

    public static String toDottedPath(Path fsPath) {
        return PathUtils.constructFullPath(PathUtils.toPathComponents(fsPath));
    }

    public static String toDottedPath(Path parent, Path child) throws IOException {
        List<String> parentPathComponents = PathUtils.toPathComponents(parent);
        List<String> childPathComponents = PathUtils.toPathComponents(child);
        for (int i = 0; i < parentPathComponents.size(); ++i) {
            if (parentPathComponents.get(i).equals(childPathComponents.get(i))) continue;
            throw new IOException(String.format("Invalid file/directory %s listed under %s", child, parent));
        }
        return PathUtils.constructFullPath(childPathComponents.subList(parentPathComponents.size(), childPathComponents.size()));
    }

    public static List<String> toPathComponents(String fsPath) {
        if (fsPath == null) {
            return EMPTY_SCHEMA_PATHS;
        }
        StrTokenizer tokenizer = new StrTokenizer(fsPath, '/', SqlUtils.QUOTE).setIgnoreEmptyTokens(true);
        return tokenizer.getTokenList();
    }

    public static List<String> toPathComponents(Path fsPath) {
        if (fsPath == null) {
            return EMPTY_SCHEMA_PATHS;
        }
        return PathUtils.toPathComponents(fsPath.toURI().getPath());
    }

    public static String constructFullPath(Collection<String> pathComponents) {
        ArrayList<String> quotedPathComponents = Lists.newArrayList();
        for (String component : pathComponents) {
            Preconditions.checkNotNull(component);
            quotedPathComponents.add(SqlUtils.quoteIdentifier(component));
        }
        return KEY_JOINER.join(quotedPathComponents);
    }

    public static String encodeURIComponent(String component) {
        try {
            String encodedComponent = URLEncoder.encode(component, "UTF-8");
            String pattern1Str = pattern1.matcher(encodedComponent).replaceAll("(");
            String pattern2Str = pattern2.matcher(pattern1Str).replaceAll(")");
            String pattern3Str = pattern3.matcher(pattern2Str).replaceAll("%20");
            String pattern4Str = pattern4.matcher(pattern3Str).replaceAll("'");
            String pattern5Str = pattern5.matcher(pattern4Str).replaceAll("!");
            String pattern6Str = pattern6.matcher(pattern5Str).replaceAll("~");
            return pattern6Str;
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static List<String> parseFullPath(String path) {
        StrTokenizer tokenizer = new StrTokenizer(path, '.', SqlUtils.QUOTE).setIgnoreEmptyTokens(true);
        return tokenizer.getTokenList();
    }

    public static String removeQuotes(String pathComponent) {
        if (pathComponent.charAt(0) == SqlUtils.QUOTE && pathComponent.charAt(pathComponent.length() - 1) == SqlUtils.QUOTE) {
            return pathComponent.substring(1, pathComponent.length() - 1);
        }
        return pathComponent;
    }

    public static Joiner getPathJoiner() {
        return PATH_JOINER;
    }

    public static char getPathDelimiter() {
        return '.';
    }

    public static Joiner getKeyJoiner() {
        return KEY_JOINER;
    }

    public static String slugify(Collection<String> pathComponents) {
        Slugify slg = new Slugify();
        return slg.slugify(PathUtils.constructFullPath(pathComponents));
    }

    public static String relativePath(Path absolutePath, Path basePath) {
        Preconditions.checkArgument(absolutePath.isAbsolute(), "absolutePath must be an absolute path");
        Preconditions.checkArgument(basePath.isAbsolute(), "basePath must be an absolute path");
        ArrayList<String> absolutePathComponents = Lists.newArrayList(PathUtils.toPathComponents(absolutePath));
        List<String> basePathComponents = PathUtils.toPathComponents(basePath);
        boolean hasCommonPrefix = basePathComponents.isEmpty();
        for (String base : basePathComponents) {
            if (!((String)absolutePathComponents.get(0)).equals(base)) break;
            absolutePathComponents.remove(0);
            hasCommonPrefix = true;
        }
        if (hasCommonPrefix) {
            return PATH_JOINER.join(absolutePathComponents);
        }
        return absolutePath.toString();
    }

    public static void verifyNoAccessOutsideBase(Path basePath, Path givenPath) {
        if (!PathUtils.checkNoAccessOutsideBase(basePath, givenPath)) {
            throw UserException.permissionError().message("Not allowed to access files outside of the source root", new Object[0]).addContext("Source root", Path.withoutSchemeAndAuthority(basePath).toString()).addContext("Requested to path", Path.withoutSchemeAndAuthority(givenPath).toString()).build(logger);
        }
    }

    public static boolean checkNoAccessOutsideBase(Path basePath, Path givenPath) {
        String basePathNormalized = Path.withoutSchemeAndAuthority(basePath).toString();
        String givenPathNormalized = Path.withoutSchemeAndAuthority(givenPath).toString();
        return Paths.get(givenPathNormalized, new String[0]).startsWith(Paths.get(basePathNormalized, new String[0]));
    }

    public static String removeLeadingSlash(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            String newPath = path.substring(1);
            return PathUtils.removeLeadingSlash(newPath);
        }
        return path;
    }
}

