/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util.concurrent;

import cdjd.com.dremio.common.util.Closeable;

public class ContextClassLoaderSwapper
implements Closeable {
    private final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();

    private ContextClassLoaderSwapper(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    @Override
    public void close() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    public static Closeable swapClassLoader(Class<?> classObj) {
        return new ContextClassLoaderSwapper(classObj.getClassLoader());
    }
}

