/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.util.ObjectType;
import cdjd.org.apache.arrow.vector.types.TimeUnit;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MajorTypeHelper {
    public static Types.MinorType getArrowMinorType(TypeProtos.MinorType minorType) {
        switch (minorType) {
            case LATE: {
                return Types.MinorType.NULL;
            }
            case TIMESTAMP: {
                return Types.MinorType.TIMESTAMPMILLI;
            }
            case TIME: {
                return Types.MinorType.TIMEMILLI;
            }
            case DATE: {
                return Types.MinorType.DATEMILLI;
            }
        }
        return Types.MinorType.valueOf(minorType.name());
    }

    public static TypeProtos.MajorType getMajorTypeForField(Field field) {
        if (field.getType() instanceof ObjectType) {
            return cdjd.com.dremio.common.types.Types.required(TypeProtos.MinorType.GENERIC_OBJECT);
        }
        return MajorTypeHelper.getMajorTypeForArrowType(field.getType(), field.getChildren());
    }

    public static TypeProtos.MajorType getMajorTypeForArrowType(ArrowType arrowType, List<Field> children) {
        TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(MajorTypeHelper.getMinorTypeFromArrowMinorType(Types.getMinorTypeForArrowType(arrowType))).setMode(TypeProtos.DataMode.OPTIONAL);
        ArrowType.ArrowTypeID fieldType = arrowType.getTypeID();
        block0 : switch (fieldType) {
            case Decimal: {
                builder.setPrecision(((ArrowType.Decimal)arrowType).getPrecision()).setScale(((ArrowType.Decimal)arrowType).getScale());
                break;
            }
            case Utf8: 
            case Binary: {
                builder.setPrecision(65536);
                break;
            }
            case Timestamp: {
                TimeUnit unit = ((ArrowType.Timestamp)arrowType).getUnit();
                switch (unit) {
                    case SECOND: {
                        builder.setPrecision(0);
                        break block0;
                    }
                    case MILLISECOND: {
                        builder.setPrecision(3);
                        break block0;
                    }
                    case MICROSECOND: {
                        builder.setPrecision(6);
                        break block0;
                    }
                    case NANOSECOND: {
                        builder.setPrecision(9);
                        break block0;
                    }
                }
                throw new AssertionError((Object)("Arrow TimeUnit " + (Object)((Object)unit) + "not supported"));
            }
            case Union: {
                for (Field child : children) {
                    builder.addSubType(MajorTypeHelper.getMinorTypeFromArrowMinorType(Types.getMinorTypeForArrowType(child.getType())));
                }
                break;
            }
        }
        return builder.build();
    }

    public static ArrowType getArrowTypeForMajorType(TypeProtos.MajorType majorType) {
        if (majorType.getMinorType() == TypeProtos.MinorType.DECIMAL) {
            return new ArrowType.Decimal(majorType.getPrecision(), majorType.getScale());
        }
        return MajorTypeHelper.getArrowMinorType(majorType.getMinorType()).getType();
    }

    public static Field getFieldForNameAndMajorType(String name, TypeProtos.MajorType majorType) {
        try {
            return new Field(name, true, MajorTypeHelper.getArrowTypeForMajorType(majorType), MajorTypeHelper.getChildrenForMajorType(majorType));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Could not get field for name: %s, majorType:%s", name, majorType), e);
        }
    }

    public static List<Field> getChildrenForMajorType(TypeProtos.MajorType majorType) {
        ArrayList<Field> children = new ArrayList<Field>();
        switch (majorType.getMinorType()) {
            case UNION: {
                for (TypeProtos.MinorType minorType : majorType.getSubTypeList()) {
                    children.add(Field.nullable("", MajorTypeHelper.getArrowMinorType(minorType).getType()));
                }
                return children;
            }
        }
        return Collections.emptyList();
    }

    public static List<Types.MinorType> getArrowSubtypes(List<TypeProtos.MinorType> subTypes) {
        if (subTypes == null) {
            return null;
        }
        ArrayList<Types.MinorType> arrowMinorTypes = new ArrayList<Types.MinorType>();
        for (TypeProtos.MinorType minorType : subTypes) {
            arrowMinorTypes.add(MajorTypeHelper.getArrowMinorType(minorType));
        }
        return arrowMinorTypes;
    }

    public static TypeProtos.MinorType getMinorTypeFromArrowMinorType(Types.MinorType arrowMinorType) {
        switch (arrowMinorType) {
            case TIMESTAMPMILLI: {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            case TIMESTAMPMILLITZ: {
                return TypeProtos.MinorType.TIMESTAMPTZ;
            }
            case TIMEMILLI: {
                return TypeProtos.MinorType.TIME;
            }
            case DATEMILLI: {
                return TypeProtos.MinorType.DATE;
            }
        }
        return TypeProtos.MinorType.valueOf(arrowMinorType.name());
    }
}

