/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import cdjd.com.google.common.base.Charsets;
import cdjd.com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final char separatorChar = '/';
    public static final String separator = "/";

    private static URL getResource(String fileName) throws IOException {
        try {
            return Resources.getResource(FileUtils.class, fileName);
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException(String.format("Unable to find file on path %s", fileName));
        }
    }

    public static File getResourceAsFile(String fileName) throws IOException {
        return new File(FileUtils.getResource(fileName).getPath());
    }

    public static String getResourceAsString(String fileName) throws IOException {
        return Resources.toString(FileUtils.getResource(fileName), Charsets.UTF_8);
    }
}

