/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

public enum DremioEdition {
    OSS,
    COMMUNITY,
    ENTERPRISE,
    MARKETPLACE;

    private static final DremioEdition CURRENT;

    public static DremioEdition get() {
        return CURRENT;
    }

    public static String getAsString() {
        switch (CURRENT) {
            case OSS: {
                return "OSS";
            }
            case COMMUNITY: {
                return "CE";
            }
            case ENTERPRISE: {
                return "EE";
            }
            case MARKETPLACE: {
                return "ME";
            }
        }
        return CURRENT.name();
    }

    private static boolean is(String name) {
        try {
            Class.forName("com.dremio.edition." + name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        DremioEdition edition = OSS;
        if (DremioEdition.is("Marketplace")) {
            edition = MARKETPLACE;
        } else if (DremioEdition.is("Enterprise")) {
            edition = ENTERPRISE;
        } else if (DremioEdition.is("Community")) {
            edition = COMMUNITY;
        }
        CURRENT = edition;
    }
}

