/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.tracing;

import cdjd.com.google.common.base.Preconditions;
import cdjd.io.opentracing.Scope;
import cdjd.io.opentracing.Span;
import cdjd.io.opentracing.Tracer;
import cdjd.io.opentracing.noop.NoopSpan;
import cdjd.io.opentracing.noop.NoopSpanBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TracingUtils {
    private TracingUtils() {
    }

    public static Tracer.SpanBuilder childSpanBuilder(Tracer tracer, String spanName, String ... tags) {
        return TracingUtils.childSpanBuilder(tracer, tracer.activeSpan(), spanName, tags);
    }

    public static Tracer.SpanBuilder childSpanBuilder(Tracer tracer, Span parent, String spanName, String ... tags) {
        Preconditions.checkArgument(tags.length % 2 == 0);
        if (parent == null || parent.equals(NoopSpan.INSTANCE)) {
            return NoopSpanBuilder.INSTANCE;
        }
        Tracer.SpanBuilder builder = tracer.buildSpan(spanName);
        for (int i = 0; i < tags.length; i += 2) {
            builder.withTag(tags[i], tags[i + 1]);
        }
        return builder;
    }

    public static Span buildChildSpan(Tracer tracer, String spanName, String ... tags) {
        return TracingUtils.childSpanBuilder(tracer, spanName, tags).start();
    }

    /*
     * Loose catch block
     */
    public static <R> R trace(Function<Span, R> work, Tracer tracer, String operation, String ... tags) {
        Span span = TracingUtils.buildChildSpan(tracer, operation, tags);
        try {
            R r;
            try (Scope s2 = tracer.activateSpan(span);){
                r = work.apply(span);
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    public static <R> R trace(Supplier<R> work, Tracer tracer, String operation, String ... tags) {
        return (R)TracingUtils.trace((Span span) -> work.get(), tracer, operation, tags);
    }

    public static void trace(Consumer<Span> work, Tracer tracer, String operation, String ... tags) {
        TracingUtils.trace((Span span) -> {
            work.accept((Span)span);
            return null;
        }, tracer, operation, tags);
    }

    public static void trace(Runnable work, Tracer tracer, String operation, String ... tags) {
        TracingUtils.trace((Span span) -> {
            work.run();
            return null;
        }, tracer, operation, tags);
    }
}

