/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.scanner;

import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.common.scanner.ClassPathScanner;
import cdjd.com.dremio.common.scanner.persistence.ScanResult;
import cdjd.com.fasterxml.jackson.databind.ObjectMapper;
import cdjd.com.fasterxml.jackson.databind.ObjectReader;
import cdjd.com.fasterxml.jackson.databind.ObjectWriter;
import cdjd.com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildTimeScan {
    private static final Logger logger = LoggerFactory.getLogger(BuildTimeScan.class);
    private static final String REGISTRY_FILE = "META-INF/dremio-module-scan/registry.json";
    private static final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final ObjectReader reader = mapper.readerFor(ScanResult.class);
    private static final ObjectWriter writer = mapper.writerFor(ScanResult.class);

    static Collection<URL> getPrescannedPaths() {
        return ClassPathScanner.forResource(REGISTRY_FILE, true);
    }

    static ScanResult load() {
        return BuildTimeScan.loadExcept(null);
    }

    private static ScanResult loadExcept(URL ignored) {
        Collection<URL> preScanned = ClassPathScanner.forResource(REGISTRY_FILE, false);
        ScanResult result = null;
        for (URL u : preScanned) {
            if (ignored != null && u.toString().startsWith(ignored.toString())) continue;
            try {
                InputStream reflections = u.openStream();
                Throwable throwable = null;
                try {
                    ScanResult ref = (ScanResult)reader.readValue(reflections);
                    if (result == null) {
                        result = ref;
                        continue;
                    }
                    result = result.merge(ref);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reflections == null) continue;
                    if (throwable != null) {
                        try {
                            reflections.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reflections.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("can't read function registry at " + u, e);
            }
        }
        if (result != null) {
            if (logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (URL u : preScanned) {
                    sb.append('\t');
                    sb.append(u.toExternalForm());
                    sb.append('\n');
                }
                logger.info(String.format("Loaded prescanned packages %s from locations:\n%s", result.getScannedPackages(), sb));
            }
            return result;
        }
        return ClassPathScanner.emptyResult();
    }

    private static void save(ScanResult scanResult, File file) {
        try {
            writer.writeValue(file, (Object)scanResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("Usage: java {cp} " + ClassPathScanner.class.getName() + " path/to/scan");
        }
        String basePath = args[0];
        System.out.println("Scanning: " + basePath);
        File registryFile = new File(basePath, REGISTRY_FILE);
        File dir = registryFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs() || !dir.isDirectory()) {
            throw new IllegalArgumentException("could not create dir " + dir.getAbsolutePath());
        }
        SabotConfig config = SabotConfig.create();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        URL url = new URL("file:" + basePath);
        Collection<URL> markedPaths = ClassPathScanner.getMarkedPaths();
        if (!markedPaths.contains(url)) {
            throw new IllegalArgumentException(url + " not in " + markedPaths);
        }
        List<String> packagePrefixes = ClassPathScanner.getPackagePrefixes(config);
        List<String> baseClasses = ClassPathScanner.getScannedBaseClasses(config);
        List<String> scannedAnnotations = ClassPathScanner.getScannedAnnotations(config);
        ScanResult preScanned = BuildTimeScan.loadExcept(url);
        ScanResult scan = ClassPathScanner.scan(Arrays.asList(url), packagePrefixes, baseClasses, scannedAnnotations, preScanned);
        BuildTimeScan.save(scan, registryFile);
    }
}

