/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.perf;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Timer {
    private static final Logger logger = LoggerFactory.getLogger(Timer.class);
    private static ThreadLocal<Ticker> tickerPerThread = new ThreadLocal();
    private static final AtomicLong nextAsyncId = new AtomicLong(0L);
    private static final TimedBlock NO_OP_TIMED_BLOCK = new TimedBlock("no-op-timed-block", new Ticker(){

        @Override
        public void addID(String id) {
        }

        @Override
        public int nextId() {
            return 0;
        }

        @Override
        public void tick(String name, int id) {
        }

        @Override
        public void tock(String name, int id) {
        }

        @Override
        public void log(long reqId, String message) {
        }
    }){

        @Override
        public void addID(String id) {
        }

        @Override
        public void close() {
        }
    };

    public static Ticker longLivedTicker() {
        Ticker ticker = new Ticker();
        tickerPerThread.set(ticker);
        return ticker;
    }

    public static void release() {
        tickerPerThread.remove();
    }

    public static boolean enabled() {
        return logger.isTraceEnabled();
    }

    private Timer() {
    }

    public static TimedBlock time(final String name) {
        if (!Timer.enabled()) {
            return NO_OP_TIMED_BLOCK;
        }
        Ticker currentTicker = tickerPerThread.get();
        if (currentTicker != null) {
            return new TimedBlock(name, currentTicker);
        }
        final Ticker newTicker = Timer.longLivedTicker();
        return new TimedBlock(name, newTicker){

            @Override
            public void close() {
                super.close();
                newTicker.log(nextAsyncId.incrementAndGet(), "async " + name);
                Timer.release();
            }
        };
    }

    public static class Ticker {
        private final List<Event> events = new ArrayList<Event>();
        private int nextId = 0;
        private final long start = System.nanoTime();
        private Set<String> customIDs;

        private Ticker() {
        }

        public void addID(String id) {
            if (this.customIDs == null) {
                this.customIDs = new LinkedHashSet<String>(1);
            }
            this.customIDs.add(id);
        }

        public int nextId() {
            return this.nextId++;
        }

        public void tick(String name, int id) {
            this.event(name, true, id);
        }

        public void tock(String name, int id) {
            this.event(name, false, id);
        }

        private void event(String name, boolean tick, int id) {
            long t = System.nanoTime();
            this.events.add(new Event(name, (t - this.start) / 1000000L, tick, id));
        }

        public void log(long reqId, String message) {
            if (!logger.isTraceEnabled()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(reqId).append(": ");
            sb.append((System.nanoTime() - this.start) / 1000000L).append("ms ");
            sb.append(message);
            if (this.customIDs != null) {
                for (String customID : this.customIDs) {
                    sb.append(" ").append(customID);
                }
            }
            int indent = 15;
            Event previous = null;
            for (Event e : this.events) {
                int i;
                String ts = (previous == null ? e.t : e.t - previous.t) + "ms";
                String pr = reqId + "-" + e.id + ": " + ts;
                if (e.tick) {
                    sb.append("\n");
                    sb.append(pr);
                    for (i = pr.length(); i < indent; ++i) {
                        sb.append(" ");
                    }
                    sb.append("{ ");
                    sb.append(e.name);
                    ++indent;
                } else if (previous != null && previous.tick && previous.name.equals(e.name) && previous.id == e.id) {
                    --indent;
                    sb.append(" ").append(ts).append(" }");
                } else {
                    --indent;
                    sb.append("\n");
                    sb.append(pr);
                    for (i = pr.length(); i < indent; ++i) {
                        sb.append(" ");
                    }
                    sb.append("} ");
                    sb.append(e.name);
                }
                previous = e;
            }
            logger.trace(sb.toString());
        }
    }

    private static final class Event {
        private final long t;
        private final String name;
        private final boolean tick;
        private final int id;

        public Event(String name, long t, boolean tick, int id) {
            this.name = name;
            this.t = t;
            this.tick = tick;
            this.id = id;
        }
    }

    public static class TimedBlock
    implements AutoCloseable {
        private final int id;
        private final String name;
        private final Ticker ticker;

        public TimedBlock(String name, Ticker ticker) {
            this.ticker = ticker;
            this.name = name;
            this.id = ticker.nextId();
            ticker.tick(name, this.id);
        }

        public void addID(String id) {
            this.ticker.addID(id);
        }

        @Override
        public void close() {
            this.ticker.tock(this.name, this.id);
        }
    }
}

