/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.memory;

import cdjd.com.dremio.common.collections.Tuple;
import cdjd.org.apache.arrow.memory.AllocationOutcomeDetails;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.OutOfMemoryException;
import cdjd.org.apache.arrow.memory.util.CommonUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;

public final class MemoryDebugInfo {
    private static final int NUM_LEVELS_FROM_ROOT_TO_OPERATOR = 6;
    private static final int MAX_NODES_PER_LEVEL = 10;

    private static void print(StringBuilder sb, BufferAllocator current, int currentLevel, int maxLevels) {
        if (currentLevel > maxLevels) {
            return;
        }
        Collection<BufferAllocator> childAllocators = current.getChildAllocators();
        CommonUtil.indent(sb, currentLevel).append("Allocator(").append(current.getName()).append(") ").append(current.getInitReservation()).append('/').append(current.getAllocatedMemory()).append('/').append(current.getPeakMemoryAllocation()).append('/').append(current.getLimit()).append(" (res/actual/peak/limit)").append(" numChildAllocators:").append(childAllocators.size()).append('\n');
        for (BufferAllocator child : MemoryDebugInfo.pruneAllocatorList(childAllocators)) {
            MemoryDebugInfo.print(sb, child, currentLevel + 1, maxLevels);
        }
    }

    private static Collection<BufferAllocator> pruneAllocatorList(Collection<BufferAllocator> allocators) {
        if (allocators.size() <= 10) {
            return allocators;
        }
        return allocators.stream().map(allocator -> Tuple.of(allocator.getAllocatedMemory(), allocator)).sorted(Comparator.comparingLong(tuple -> -((Long)tuple.first).longValue())).limit(10L).map(tuple -> (BufferAllocator)tuple.second).collect(Collectors.toList());
    }

    private static String getSummary(BufferAllocator start, int numLevels) {
        StringBuilder sb = new StringBuilder();
        MemoryDebugInfo.print(sb, start, 0, numLevels);
        return sb.toString();
    }

    public static String getSummaryFromRoot(BufferAllocator allocator) {
        BufferAllocator root = allocator;
        while (root.getParentAllocator() != null) {
            root = root.getParentAllocator();
        }
        return MemoryDebugInfo.getSummary(root, 6);
    }

    public static String getDetailsOnAllocationFailure(OutOfMemoryException exception, BufferAllocator allocator) {
        BufferAllocator failedAtAllocator = null;
        StringBuilder sb = new StringBuilder();
        Optional<AllocationOutcomeDetails> outcomeDetails = exception.getOutcomeDetails();
        if (outcomeDetails.isPresent()) {
            sb.append(outcomeDetails.get().toString());
            failedAtAllocator = outcomeDetails.get().getFailedAllocator();
        }
        String summary = failedAtAllocator == null ? MemoryDebugInfo.getSummaryFromRoot(allocator) : (failedAtAllocator.getParentAllocator() == null ? MemoryDebugInfo.getSummaryFromRoot(failedAtAllocator) : MemoryDebugInfo.getSummary(failedAtAllocator, 3));
        sb.append("\nAllocator dominators:\n");
        sb.append(summary);
        return sb.toString();
    }
}

