/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.expression;

import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;

public class SqlTypeNameVisitor
implements ArrowType.ArrowTypeVisitor<String> {
    @Override
    public String visit(ArrowType.Null paramNull) {
        return "NULL";
    }

    @Override
    public String visit(ArrowType.Struct paramStruct_) {
        return "MAP";
    }

    @Override
    public String visit(ArrowType.List paramList) {
        return "ARRAY";
    }

    @Override
    public String visit(ArrowType.Union paramUnion) {
        return "UNION";
    }

    @Override
    public String visit(ArrowType.Int paramInt) {
        switch (paramInt.getBitWidth()) {
            case 8: {
                return "TINYINT";
            }
            case 16: {
                return "SMALLINT";
            }
            case 32: {
                return "INTEGER";
            }
            case 64: {
                return "BIGINT";
            }
        }
        throw new IllegalStateException("unable to report sql type for integer of width " + paramInt.getBitWidth());
    }

    @Override
    public String visit(ArrowType.FloatingPoint paramFloatingPoint) {
        switch (paramFloatingPoint.getPrecision()) {
            case SINGLE: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
        }
        throw new IllegalStateException("unable to report sql type for floating point of width " + (Object)((Object)paramFloatingPoint.getPrecision()));
    }

    @Override
    public String visit(ArrowType.Utf8 paramUtf8) {
        return "CHARACTER VARYING";
    }

    @Override
    public String visit(ArrowType.Binary paramBinary) {
        return "BINARY VARYING";
    }

    @Override
    public String visit(ArrowType.Bool paramBool) {
        return "BOOLEAN";
    }

    @Override
    public String visit(ArrowType.Decimal paramDecimal) {
        return "DECIMAL";
    }

    @Override
    public String visit(ArrowType.Date paramDate) {
        return "DATE";
    }

    @Override
    public String visit(ArrowType.Time paramTime) {
        return "TIME";
    }

    @Override
    public String visit(ArrowType.Timestamp paramTimestamp) {
        return "TIMESTAMP";
    }

    @Override
    public String visit(ArrowType.Interval paramInterval) {
        switch (paramInterval.getUnit()) {
            case DAY_TIME: {
                return "INTERVAL DAY TO SECOND";
            }
            case YEAR_MONTH: {
                return "INTERVAL YEAR TO MONTH";
            }
        }
        throw new IllegalStateException("unable to determine sql type for interval with unit " + (Object)((Object)paramInterval.getUnit()));
    }

    @Override
    public String visit(ArrowType.FixedSizeList paramList) {
        return "ARRAY";
    }

    @Override
    public String visit(ArrowType.FixedSizeBinary paramList) {
        return "BINARY";
    }

    @Override
    public String visit(ArrowType.LargeBinary paramLargeBinary) {
        throw new UnsupportedOperationException("Dremio does not support LargeBinary");
    }

    @Override
    public String visit(ArrowType.LargeUtf8 paramLargeUtf8) {
        throw new UnsupportedOperationException("Dremio does not support LargeUtf8");
    }

    @Override
    public String visit(ArrowType.Duration paramDuration) {
        throw new UnsupportedOperationException("Dremio does not support duration.");
    }

    @Override
    public String visit(ArrowType.Map paramDuration) {
        throw new UnsupportedOperationException("Dremio does not support map.");
    }
}

