/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.expression;

import cdjd.com.dremio.common.expression.AbstractArrowTypeVisitor;
import cdjd.com.dremio.common.expression.CompleteType;
import cdjd.org.apache.arrow.vector.types.DateUnit;
import cdjd.org.apache.arrow.vector.types.FloatingPointPrecision;
import cdjd.org.apache.arrow.vector.types.IntervalUnit;
import cdjd.org.apache.arrow.vector.types.TimeUnit;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;

public class Describer {
    private static TypeDescriber INSTANCE = new TypeDescriber();

    public static String describe(ArrowType type) {
        return type.accept(INSTANCE);
    }

    public static String describe(CompleteType type) {
        if (type == CompleteType.OBJECT) {
            return "object";
        }
        if (type == CompleteType.NULL) {
            return "null";
        }
        if (type == CompleteType.LATE) {
            return "late";
        }
        return Describer.describe(type.toField(""), false);
    }

    public static String describe(Iterable<Field> fields) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Field f : fields) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(Describer.describe(f));
            first = false;
        }
        return sb.toString();
    }

    public static String describeInternal(ArrowType type) {
        Types.MinorType mtype = Types.getMinorTypeForArrowType(type);
        return mtype.name().toLowerCase();
    }

    public static String describeWithLineBreaks(Iterable<Field> fields) {
        StringBuilder sb = new StringBuilder();
        for (Field f : fields) {
            sb.append(Describer.describe(f));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String describe(Field field) {
        return field.getType().accept(new FieldDescriber(field, true));
    }

    private static String describe(Field field, boolean includeName) {
        return field.getType().accept(new FieldDescriber(field, includeName));
    }

    private static class TypeDescriber
    implements ArrowType.ArrowTypeVisitor<String> {
        private TypeDescriber() {
        }

        @Override
        public String visit(ArrowType.Null type) {
            return "null";
        }

        @Override
        public String visit(ArrowType.Struct type) {
            return "struct";
        }

        @Override
        public String visit(ArrowType.List type) {
            return "list";
        }

        @Override
        public String visit(ArrowType.Union type) {
            return "union";
        }

        @Override
        public String visit(ArrowType.Int type) {
            return (type.getIsSigned() ? "" : "u") + "int" + type.getBitWidth();
        }

        @Override
        public String visit(ArrowType.FloatingPoint type) {
            return type.getPrecision() == FloatingPointPrecision.SINGLE ? "float" : "double";
        }

        @Override
        public String visit(ArrowType.Utf8 type) {
            return "varchar";
        }

        @Override
        public String visit(ArrowType.Binary type) {
            return "varbinary";
        }

        @Override
        public String visit(ArrowType.Bool type) {
            return "boolean";
        }

        @Override
        public String visit(ArrowType.Decimal type) {
            return String.format("decimal(%d,%d)", type.getPrecision(), type.getScale());
        }

        @Override
        public String visit(ArrowType.Date type) {
            String name = "date";
            DateUnit unit = type.getUnit();
            if (unit == DateUnit.MILLISECOND) {
                return name;
            }
            return String.format("%s(%s)", new Object[]{name, unit});
        }

        @Override
        public String visit(ArrowType.Time type) {
            String name = "time";
            TimeUnit unit = type.getUnit();
            if (unit == TimeUnit.MILLISECOND) {
                return name;
            }
            return String.format("%s(%s)", new Object[]{name, unit});
        }

        @Override
        public String visit(ArrowType.Timestamp type) {
            String name = "timestamp";
            String timezone = type.getTimezone();
            TimeUnit unit = type.getUnit();
            if (timezone == null && unit == TimeUnit.MILLISECOND) {
                return name;
            }
            return String.format("%s(%s,%s)", name, timezone == null ? "?" : timezone, unit.name());
        }

        @Override
        public String visit(ArrowType.Interval type) {
            return type.getUnit() == IntervalUnit.DAY_TIME ? "interval_day" : "interval_year";
        }

        @Override
        public String visit(ArrowType.FixedSizeList type) {
            return String.format("list(%d)", type.getListSize());
        }

        @Override
        public String visit(ArrowType.FixedSizeBinary type) {
            return String.format("binary(%d)", type.getByteWidth());
        }

        @Override
        public String visit(ArrowType.LargeBinary paramLargeBinary) {
            throw new UnsupportedOperationException("Dremio does not support LargeBinary yet");
        }

        @Override
        public String visit(ArrowType.LargeUtf8 paramLargeUtf8) {
            throw new UnsupportedOperationException("Dremio does not support LargeUtf8 yet");
        }

        @Override
        public String visit(ArrowType.Duration type) {
            throw new UnsupportedOperationException("Dremio does not support duration yet.");
        }

        @Override
        public String visit(ArrowType.Map type) {
            throw new UnsupportedOperationException("Dremio does not support map yet.");
        }
    }

    public static final class FieldDescriber
    extends AbstractArrowTypeVisitor<String> {
        private final Field field;
        private final boolean includeName;

        public FieldDescriber(Field field, boolean includeName) {
            this.field = field;
            this.includeName = includeName;
        }

        @Override
        public String visit(ArrowType.Struct type) {
            StringBuilder sb = new StringBuilder();
            if (this.includeName) {
                sb.append(this.field.getName());
                sb.append("::");
            }
            sb.append("struct<");
            boolean first = true;
            for (Field f : this.field.getChildren()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(Describer.describe(f, true));
            }
            sb.append(">");
            return sb.toString();
        }

        @Override
        public String visit(ArrowType.List type) {
            StringBuilder sb = new StringBuilder();
            if (this.includeName) {
                sb.append(this.field.getName());
                sb.append("::");
            }
            sb.append("list<");
            sb.append(Describer.describe(this.field.getChildren().get(0), false));
            sb.append(">");
            return sb.toString();
        }

        @Override
        public String visit(ArrowType.Union type) {
            StringBuilder sb = new StringBuilder();
            if (this.includeName) {
                sb.append(this.field.getName());
                sb.append("::");
            }
            sb.append("union<");
            boolean first = true;
            for (Field f : this.field.getChildren()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(Describer.describe(f, false));
            }
            sb.append(">");
            return sb.toString();
        }

        @Override
        protected String visitGeneric(ArrowType type) {
            String typeStr = Describer.describe(type);
            if (!this.includeName) {
                return typeStr;
            }
            return this.field.getName() + "::" + typeStr;
        }
    }
}

