/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.exceptions;

import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

class UserExceptionContext {
    private final String errorId = UUID.randomUUID().toString();
    private final List<String> contextList = new ArrayList<String>();
    private CoordinationProtos.NodeEndpoint endpoint;

    UserExceptionContext() {
    }

    void add(String context) {
        this.contextList.add(context);
    }

    void add(CoordinationProtos.NodeEndpoint endpoint) {
        if (this.endpoint == null) {
            this.endpoint = endpoint;
        }
    }

    void add(String context, String value) {
        this.add(context + " " + value);
    }

    void add(String context, long value) {
        this.add(context + " " + value);
    }

    void add(String context, double value) {
        this.add(context + " " + value);
    }

    void push(String context) {
        this.contextList.add(0, context);
    }

    void push(String context, String value) {
        this.push(context + " " + value);
    }

    void push(String context, long value) {
        this.push(context + " " + value);
    }

    void push(String context, double value) {
        this.push(context + " " + value);
    }

    String getErrorId() {
        return this.errorId;
    }

    CoordinationProtos.NodeEndpoint getEndpoint() {
        return this.endpoint;
    }

    String generateContextMessage(boolean includeErrorIdAndIdentity) {
        StringBuilder sb = new StringBuilder();
        for (String context : this.contextList) {
            sb.append(context).append("\n");
        }
        if (includeErrorIdAndIdentity) {
            sb.append("\n[Error Id: ");
            sb.append(this.errorId).append(" ");
            if (this.endpoint != null) {
                sb.append("on ").append(this.endpoint.getAddress()).append(":").append(this.endpoint.getUserPort());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    List<String> getContextAsStrings() {
        return ImmutableList.copyOf(this.contextList);
    }
}

