/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.exceptions;

import cdjd.com.dremio.common.exceptions.AdditionalExceptionContext;
import cdjd.com.dremio.common.exceptions.ErrorHelper;
import cdjd.com.dremio.common.exceptions.UserExceptionContext;
import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.google.protobuf.ByteString;
import cdjd.org.apache.arrow.memory.OutOfMemoryException;
import cdjd.org.apache.arrow.vector.util.SchemaChangeRuntimeException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserException
extends RuntimeException {
    private static final Logger logger = LoggerFactory.getLogger(UserException.class);
    public static final String MEMORY_ERROR_MSG = "Query was cancelled because it exceeded the memory limits set by the administrator.";
    public static final String OOM_MSG = "Query canceled - out of memory, check the query profile for details";
    public static final String QUERY_REJECTED_MSG = "Rejecting query because it exceeded the maximum allowed number of live queries in a single coordinator";
    private final UserBitShared.DremioPBError.ErrorType errorType;
    private final UserExceptionContext context;
    private final ByteString rawAdditionalContext;

    public static Builder invalidMetadataError() {
        return UserException.invalidMetadataError(null);
    }

    public static Builder invalidMetadataError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.INVALID_DATASET_METADATA, cause);
    }

    public static Builder schemaChangeError() {
        return UserException.schemaChangeError(new SchemaChangeRuntimeException("Schema change error"));
    }

    public static Builder schemaChangeError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.SCHEMA_CHANGE, cause);
    }

    public static Builder resourceTimeoutError() {
        return UserException.resourceTimeoutError(null);
    }

    public static Builder resourceTimeoutError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.RESOURCE_TIMEOUT, cause);
    }

    public static Builder jsonFieldChangeError() {
        return UserException.jsonFieldChangeError(null);
    }

    public static Builder jsonFieldChangeError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.JSON_FIELD_CHANGE, cause);
    }

    public static Builder memoryError(Throwable cause) {
        Builder b = UserException.builder(UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY, cause).message(MEMORY_ERROR_MSG, new Object[0]);
        if (cause != null) {
            b.addContext(cause.getMessage());
        }
        return b;
    }

    public static Builder memoryError() {
        return UserException.memoryError(null);
    }

    @Deprecated
    public static Builder systemError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.SYSTEM, cause);
    }

    public static Builder connectionError() {
        return UserException.connectionError(null);
    }

    public static Builder connectionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.CONNECTION, cause);
    }

    public static Builder dataReadError() {
        return UserException.dataReadError(null);
    }

    public static Builder dataReadError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.DATA_READ, cause);
    }

    public static Builder sourceInBadState() {
        return UserException.sourceInBadState(null);
    }

    public static Builder sourceInBadState(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.SOURCE_BAD_STATE, cause);
    }

    public static Builder dataWriteError() {
        return UserException.dataWriteError(null);
    }

    public static Builder dataWriteError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.DATA_WRITE, cause);
    }

    public static Builder functionError() {
        return UserException.functionError(null);
    }

    public static Builder functionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.FUNCTION, cause);
    }

    public static Builder parseError() {
        return UserException.parseError(null);
    }

    public static Builder parseError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.PARSE, cause);
    }

    public static Builder validationError() {
        return UserException.validationError(null);
    }

    public static Builder validationError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.VALIDATION, cause);
    }

    public static Builder reflectionError() {
        return UserException.reflectionError(null);
    }

    public static Builder reflectionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.REFLECTION_ERROR, cause);
    }

    public static Builder permissionError() {
        return UserException.permissionError(null);
    }

    public static Builder permissionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.PERMISSION, cause);
    }

    public static Builder planError() {
        return UserException.planError(null);
    }

    public static Builder planError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.PLAN, cause);
    }

    public static Builder resourceError() {
        return UserException.resourceError(null);
    }

    public static Builder resourceError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.RESOURCE, cause);
    }

    public static Builder unsupportedError() {
        return UserException.unsupportedError(null);
    }

    public static Builder unsupportedError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.UNSUPPORTED_OPERATION, cause);
    }

    public static Builder ioExceptionError() {
        return UserException.ioExceptionError(null);
    }

    public static Builder ioExceptionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.IO_EXCEPTION, cause);
    }

    public static Builder concurrentModificationError() {
        return UserException.concurrentModificationError(null);
    }

    public static Builder concurrentModificationError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.CONCURRENT_MODIFICATION, cause);
    }

    protected static Builder builder(UserBitShared.DremioPBError.ErrorType type, Throwable cause) {
        return new Builder(type, cause);
    }

    protected UserException(UserBitShared.DremioPBError.ErrorType errorType, String message, Throwable cause, ByteString rawAdditionalContext) {
        super(message, cause);
        this.errorType = errorType;
        this.context = new UserExceptionContext();
        this.rawAdditionalContext = rawAdditionalContext;
    }

    private UserException(Builder builder) {
        super(builder.message, builder.cause);
        this.errorType = builder.errorType;
        this.context = builder.context;
        this.rawAdditionalContext = builder.rawAdditionalContext;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public String getErrorIdWithIdentity() {
        CoordinationProtos.NodeEndpoint endpoint = this.context.getEndpoint();
        if (endpoint == null) {
            return "ErrorId: " + this.context.getErrorId();
        }
        return "ErrorId: " + this.context.getErrorId() + " on " + endpoint.getAddress() + ":" + endpoint.getUserPort();
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    public String getVerboseMessage() {
        return this.getVerboseMessage(true);
    }

    public String getVerboseMessage(boolean includeErrorIdAndIdentity) {
        return this.generateMessage(includeErrorIdAndIdentity) + "\n\n" + ErrorHelper.buildCausesMessage(this.getCause());
    }

    public UserBitShared.DremioPBError getOrCreatePBError(boolean verbose) {
        UserBitShared.DremioPBError.Builder builder = UserBitShared.DremioPBError.newBuilder();
        builder.setErrorType(this.errorType);
        builder.setErrorId(this.context.getErrorId());
        if (this.context.getEndpoint() != null) {
            builder.setEndpoint(this.context.getEndpoint());
        }
        builder.setMessage(this.getVerboseMessage());
        builder.setOriginalMessage(this.getOriginalMessage());
        if (this.getCause() != null) {
            builder.setException(ErrorHelper.getWrapper(this.getCause()));
        }
        builder.addAllContext(this.context.getContextAsStrings());
        if (this.rawAdditionalContext != null) {
            builder.setTypeSpecificContext(this.rawAdditionalContext);
        }
        return builder.build();
    }

    public ByteString getRawAdditionalExceptionContext() {
        return this.rawAdditionalContext;
    }

    public List<String> getContextStrings() {
        return this.context.getContextAsStrings();
    }

    public String getErrorId() {
        return this.context.getErrorId();
    }

    public UserBitShared.DremioPBError.ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorLocation() {
        CoordinationProtos.NodeEndpoint ep = this.context.getEndpoint();
        if (ep != null) {
            return ep.getAddress() + ":" + ep.getUserPort();
        }
        return null;
    }

    private String generateMessage(boolean includeErrorIdAndIdentity) {
        return this.errorType + " ERROR: " + super.getMessage() + "\n\n" + this.context.generateContextMessage(includeErrorIdAndIdentity);
    }

    public static class Builder {
        private final Throwable cause;
        private final UserBitShared.DremioPBError.ErrorType errorType;
        private final UserException uex;
        private final UserExceptionContext context;
        private String message;
        private ByteString rawAdditionalContext;
        private boolean fixedMessage;

        private Builder(UserBitShared.DremioPBError.ErrorType errorType, Throwable cause) {
            this.uex = ErrorHelper.findWrappedCause(cause, UserException.class);
            if (this.uex != null) {
                this.errorType = null;
                this.context = this.uex.context;
                this.cause = cause;
            } else {
                OutOfMemoryException oom = ErrorHelper.findWrappedCause(cause, OutOfMemoryException.class);
                if (oom != null) {
                    this.errorType = UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY;
                    this.message = UserException.MEMORY_ERROR_MSG;
                    this.cause = oom;
                    this.fixedMessage = true;
                } else {
                    this.cause = cause;
                    this.errorType = errorType;
                    this.message = cause != null ? cause.getMessage() : null;
                }
                this.context = new UserExceptionContext();
            }
        }

        public Builder message(String format, Object ... args) {
            if (this.uex == null && !this.fixedMessage && format != null) {
                this.message = args == null || args.length == 0 ? format : String.format(format, args);
            }
            return this;
        }

        public Builder addIdentity(CoordinationProtos.NodeEndpoint endpoint) {
            this.context.add(endpoint);
            return this;
        }

        public Builder addContext(String value) {
            this.context.add(String.valueOf(value));
            return this;
        }

        public Builder addContext(String value, Object ... args) {
            this.context.add(String.format(value, args));
            return this;
        }

        public Builder addContext(String name, String value) {
            this.context.add(name, value);
            return this;
        }

        public Builder addContext(String name, long value) {
            this.context.add(name, value);
            return this;
        }

        public Builder addContext(String name, double value) {
            this.context.add(name, value);
            return this;
        }

        public Builder pushContext(String value) {
            this.context.push(String.valueOf(value));
            return this;
        }

        public Builder pushContext(String name, String value) {
            this.context.push(name, value);
            return this;
        }

        public Builder pushContext(String name, long value) {
            this.context.push(name, value);
            return this;
        }

        public Builder pushContext(String name, double value) {
            this.context.push(name, value);
            return this;
        }

        public Builder setAdditionalExceptionContext(AdditionalExceptionContext additionalContext) {
            assert (additionalContext.getErrorType() == this.errorType) : "error type of context and builder must match";
            this.rawAdditionalContext = additionalContext.toByteString();
            return this;
        }

        @Deprecated
        public UserException build(Logger logger) {
            boolean isSystemError;
            if (this.uex != null) {
                return this.uex;
            }
            boolean bl = isSystemError = this.errorType == UserBitShared.DremioPBError.ErrorType.SYSTEM;
            if (isSystemError) {
                this.message = ErrorHelper.getRootMessage(this.cause);
            } else if (this.message == null || this.message.length() == 0) {
                this.message = this.cause != null ? this.cause.getClass().getSimpleName() : "";
            }
            UserException newException = new UserException(this);
            if (logger != null) {
                try {
                    switch (this.errorType) {
                        case SYSTEM: {
                            logger.error(newException.getMessage(), newException);
                            break;
                        }
                        case OUT_OF_MEMORY: {
                            logger.error(newException.getMessage(), newException);
                            break;
                        }
                        case SCHEMA_CHANGE: 
                        case IO_EXCEPTION: {
                            logger.debug(newException.getMessage(), newException);
                            break;
                        }
                        case VALIDATION: 
                        case PLAN: {
                            logger.trace(newException.getMessage(), newException);
                            break;
                        }
                        default: {
                            logger.info("User Error Occurred [" + newException.getErrorIdWithIdentity() + "]", newException);
                            break;
                        }
                    }
                }
                catch (Throwable ignore) {
                    Exception e = new Exception("Failure while logging", ignore.getCause());
                    e.addSuppressed(newException);
                    e.printStackTrace();
                    newException.addSuppressed(ignore);
                }
            }
            return newException;
        }

        @Deprecated
        public UserException build() {
            return this.build(logger);
        }

        public UserException buildSilently() {
            return this.build(null);
        }
    }
}

