/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.exceptions;

import cdjd.com.dremio.exec.proto.UserBitShared;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHelper {
    private static final Logger logger = LoggerFactory.getLogger(ErrorHelper.class);
    private static final Pattern IGNORE = Pattern.compile("^(sun|com\\.sun|java).*");

    static String getRootMessage(Throwable cause) {
        String message = "";
        for (Throwable ex = cause; ex != null; ex = ex.getCause()) {
            message = ex.getClass().getSimpleName();
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            if (ex.getCause() == null || ex.getCause() == ex) break;
        }
        return message;
    }

    static String buildCausesMessage(Throwable t) {
        StringBuilder sb = new StringBuilder();
        Throwable ex = t;
        boolean cause = false;
        while (ex != null) {
            sb.append("  ");
            if (cause) {
                sb.append("Caused By ");
            }
            sb.append("(");
            sb.append(ex.getClass().getCanonicalName());
            sb.append(") ");
            sb.append(ex.getMessage());
            sb.append("\n");
            for (StackTraceElement st : ex.getStackTrace()) {
                sb.append("    ");
                sb.append(st.getClassName());
                sb.append('.');
                sb.append(st.getMethodName());
                sb.append("():");
                sb.append(st.getLineNumber());
                sb.append("\n");
            }
            cause = true;
            if (ex.getCause() != null && ex.getCause() != ex) {
                ex = ex.getCause();
                continue;
            }
            ex = null;
        }
        return sb.toString();
    }

    public static UserBitShared.ExceptionWrapper getWrapper(Throwable ex) {
        return ErrorHelper.getWrapperBuilder(ex).build();
    }

    private static UserBitShared.ExceptionWrapper.Builder getWrapperBuilder(Throwable ex) {
        return ErrorHelper.getWrapperBuilder(ex, false);
    }

    private static UserBitShared.ExceptionWrapper.Builder getWrapperBuilder(Throwable ex, boolean includeAllStack) {
        UserBitShared.ExceptionWrapper.Builder ew = UserBitShared.ExceptionWrapper.newBuilder();
        if (ex.getMessage() != null) {
            ew.setMessage(ex.getMessage());
        }
        ew.setExceptionClass(ex.getClass().getName());
        boolean isHidden = false;
        StackTraceElement[] stackTrace = ex.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ele = ex.getStackTrace()[i];
            if (ErrorHelper.include(ele, includeAllStack)) {
                if (isHidden) {
                    isHidden = false;
                }
                ew.addStackTrace(ErrorHelper.getSTWrapper(ele));
                continue;
            }
            if (isHidden) continue;
            isHidden = true;
            ew.addStackTrace(ErrorHelper.getEmptyST());
        }
        if (ex.getCause() != null && ex.getCause() != ex) {
            ew.setCause(ErrorHelper.getWrapper(ex.getCause()));
        }
        return ew;
    }

    private static boolean include(StackTraceElement ele, boolean includeAllStack) {
        return includeAllStack || !IGNORE.matcher(ele.getClassName()).matches();
    }

    private static UserBitShared.StackTraceElementWrapper.Builder getSTWrapper(StackTraceElement ele) {
        UserBitShared.StackTraceElementWrapper.Builder w = UserBitShared.StackTraceElementWrapper.newBuilder();
        w.setClassName(ele.getClassName());
        if (ele.getFileName() != null) {
            w.setFileName(ele.getFileName());
        }
        w.setIsNativeMethod(ele.isNativeMethod());
        w.setLineNumber(ele.getLineNumber());
        w.setMethodName(ele.getMethodName());
        return w;
    }

    private static UserBitShared.StackTraceElementWrapper.Builder getEmptyST() {
        UserBitShared.StackTraceElementWrapper.Builder w = UserBitShared.StackTraceElementWrapper.newBuilder();
        w.setClassName("...");
        w.setIsNativeMethod(false);
        w.setLineNumber(0);
        w.setMethodName("...");
        return w;
    }

    public static <T extends Throwable> T findWrappedCause(Throwable ex, Class<T> causeClass) {
        if (ex == null) {
            return null;
        }
        Throwable cause = ex;
        while (!causeClass.isInstance(cause)) {
            if (cause.getCause() != null && cause.getCause() != cause) {
                cause = cause.getCause();
                continue;
            }
            return null;
        }
        return (T)cause;
    }
}

