/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.concurrent;

import cdjd.com.dremio.common.concurrent.CloseableExecutorService;
import cdjd.com.dremio.common.concurrent.CloseableSchedulerThreadPool;
import cdjd.com.dremio.common.concurrent.NamedThreadFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableThreadPool
extends ThreadPoolExecutor
implements CloseableExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(CloseableThreadPool.class);

    public CloseableThreadPool(String name) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(name));
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t != null) {
            logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t);
        }
        super.afterExecute(r, t);
    }

    @Override
    public void close() {
        CloseableSchedulerThreadPool.close(this, logger);
    }
}

