/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common;

import cdjd.com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WakeupHandler {
    private static final Logger logger = LoggerFactory.getLogger(WakeupHandler.class);
    private final AtomicBoolean wakeup = new AtomicBoolean();
    private final AtomicBoolean running = new AtomicBoolean();
    private final Runnable manager;
    private final ExecutorService executor;

    public WakeupHandler(ExecutorService executor, Runnable manager) {
        this.executor = Preconditions.checkNotNull(executor, "executor service required");
        this.manager = Preconditions.checkNotNull(manager, "runnable manager required");
    }

    public Future<?> handle(String reason) {
        logger.trace("waking up manager, reason: {}", (Object)reason);
        if (!this.wakeup.compareAndSet(false, true)) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.running.get()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                while (WakeupHandler.this.wakeup.get()) {
                    if (!WakeupHandler.this.running.compareAndSet(false, true)) {
                        return;
                    }
                    try {
                        WakeupHandler.this.wakeup.set(false);
                        WakeupHandler.this.manager.run();
                    }
                    finally {
                        WakeupHandler.this.running.set(false);
                    }
                }
            }
        });
    }
}

