/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common;

import cdjd.com.dremio.common.VM;
import cdjd.org.hamcrest.CoreMatchers;
import cdjd.org.hamcrest.Matcher;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestVM {
    private final List<String> arguments;
    private final long maxDirectMemory;
    private final boolean debugEnabled;

    @Parameterized.Parameters(name="{index}: {2}")
    public static final Object[][] getParameters() {
        return new Object[][]{{1024L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=1024")}, {2048L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=2k")}, {0x300000L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=3m")}, {0x100000000L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=4g")}, {0x50000000000L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=5t")}, {6144L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=6K")}, {0x700000L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=7M")}, {0x200000000L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=8G")}, {0x90000000000L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=9T")}, {0L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=8a")}, {0L, false, Arrays.asList("-Xmx1g", "-XX:MaxDirectMemorySize=9Gb")}, {0L, false, Arrays.asList("-Xmx1g", "-agentlib:jdwp")}, {0L, true, Arrays.asList("-Xmx1g", "-Xdebug")}, {0L, true, Arrays.asList("-Xmx1g", "-agentlib:jdwp=transport=dt_socket")}};
    }

    public TestVM(long maxDirectMemory, boolean debugEnabled, List<String> arguments) {
        this.arguments = arguments;
        this.maxDirectMemory = maxDirectMemory;
        this.debugEnabled = debugEnabled;
    }

    @Test
    public void checkMaxDirectMemory() {
        Assert.assertThat((Object)VM.maxDirectMemory(this.arguments), (Matcher)CoreMatchers.is((Object)this.maxDirectMemory));
    }

    @Test
    public void checkDebugEnabled() {
        Assert.assertThat((Object)VM.isDebugEnabled(this.arguments), (Matcher)CoreMatchers.is((Object)this.debugEnabled));
    }
}

