/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common;

import java.util.LinkedList;
import java.util.concurrent.Executor;

public abstract class SerializedExecutor<R extends Runnable> {
    private boolean isProcessing = false;
    private final LinkedList<R> queuedRunnables = new LinkedList();
    private final Executor underlyingExecutor;
    private final String name;
    private final boolean useRunnableToStringForName;

    public SerializedExecutor(String name, Executor underlyingExecutor, boolean useRunnableToStringForName) {
        this.underlyingExecutor = underlyingExecutor;
        this.useRunnableToStringForName = useRunnableToStringForName;
        this.name = name;
    }

    protected abstract void runException(R var1, Throwable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(R r) {
        LinkedList<R> linkedList = this.queuedRunnables;
        synchronized (linkedList) {
            if (this.isProcessing) {
                this.queuedRunnables.addLast(r);
                return;
            }
            this.isProcessing = true;
        }
        this.underlyingExecutor.execute(new RunnableProcessor(this, r));
    }

    private static class RunnableProcessor
    implements Runnable {
        private R command;
        final /* synthetic */ SerializedExecutor this$0;

        public RunnableProcessor(R command) {
            this.this$0 = var1_1;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            String originalThreadName = currentThread.getName();
            if (!this.this$0.useRunnableToStringForName) {
                currentThread.setName(this.this$0.name);
            }
            try {
                while (true) {
                    if (this.this$0.useRunnableToStringForName) {
                        currentThread.setName(this.command.toString());
                    }
                    try {
                        this.command.run();
                    }
                    catch (Throwable e) {
                        try {
                            this.this$0.runException(this.command, e);
                        }
                        catch (AssertionError | Exception ee) {
                            throw new IllegalStateException("Exception handler threw an exception", (Throwable)ee);
                        }
                    }
                    LinkedList linkedList = this.this$0.queuedRunnables;
                    synchronized (linkedList) {
                        if (this.this$0.queuedRunnables.isEmpty()) {
                            this.this$0.isProcessing = false;
                            return;
                        }
                        this.command = (Runnable)this.this$0.queuedRunnables.removeFirst();
                    }
                }
            }
            finally {
                currentThread.setName(originalThreadName);
            }
        }
    }
}

