/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common;

import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.base.Supplier;
import cdjd.com.google.common.base.Throwables;

public class DeferredException
implements AutoCloseable {
    private Exception exception = null;
    private boolean isClosed = false;
    private final Supplier<Exception> exceptionSupplier;

    public DeferredException() {
        this(null);
    }

    public DeferredException(Supplier<Exception> exceptionSupplier) {
        this.exceptionSupplier = exceptionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(Exception exception) {
        Preconditions.checkNotNull(exception);
        DeferredException deferredException = this;
        synchronized (deferredException) {
            Preconditions.checkState(!this.isClosed);
            if (this.exception == null) {
                if (this.exceptionSupplier == null) {
                    this.exception = exception;
                } else {
                    this.exception = this.exceptionSupplier.get();
                    if (this.exception == null) {
                        this.exception = new RuntimeException("Missing root exception");
                    }
                    this.exception.addSuppressed(exception);
                }
            } else if (this.exception != exception) {
                this.exception.addSuppressed(exception);
            }
        }
    }

    public void addThrowable(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof Exception) {
            this.addException((Exception)throwable);
            return;
        }
        this.addException(new RuntimeException(throwable));
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    public synchronized boolean hasException() {
        return this.exception != null;
    }

    public synchronized Exception getAndClear() {
        Preconditions.checkState(!this.isClosed);
        if (this.exception != null) {
            Exception local = this.exception;
            this.exception = null;
            return local;
        }
        return null;
    }

    public synchronized void throwAndClear() throws Exception {
        Exception e = this.getAndClear();
        if (e != null) {
            throw e;
        }
    }

    public synchronized void throwAndClearRuntime() {
        Exception e = this.getAndClear();
        if (e != null) {
            throw Throwables.propagate(e);
        }
    }

    public synchronized void throwNoClearRuntime() {
        Exception e = this.getException();
        if (e != null) {
            throw Throwables.propagate(e);
        }
    }

    public void suppressingClose(AutoCloseable autoCloseable) {
        Preconditions.checkState(!this.isClosed);
        if (autoCloseable == null) {
            return;
        }
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            this.addException(e);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        try {
            this.throwAndClear();
        }
        finally {
            this.isClosed = true;
        }
    }
}

